package sysModel.fish;

/**
 * Exception during fish simulation.
 */
public class FishException extends RuntimeException {
     /**
     * The exception that was thrown.
     */
    private Throwable _target;

    /**
     * Constructs a FishException with a target exception.
     *
     * @param target the _target exception
     */
    public FishException(Throwable target) {
        _target = target;
    }

    /**
     * Get the thrown target exception.
     *
     * @return the thrown _target exception (cause of this exception).
     */
    public Throwable getTargetException() {
	    return _target;
    }

    /**
     * Returns the cause of this exception (the thrown target exception).
     *
     * @return  the cause of this exception.
     */
    public Throwable getCause() {
        return _target;
    }
}
