package sysModel.fish;

import java.awt.*;

/**
 * Interface for a fish display.
 *
 * @author Mathias Ricken
 */
public interface IFishDisplay {
    /**
     * Draw the fish. The Graphics2D object has been set up so that the origin is in the center of the fish. A fish that
     * is 32x32 wide should thus drawFish from (-16,-16) to (16,16).
     *
     * @param g         graphics object to drawFish on
     * @param comp      the component to drawFish on
     * @param fishColor color of the fish
     */
    void draw(Graphics2D g, Component comp, Color fishColor);
}
