package sysModel.fish.tests;

import controller.IScrollAdapter;
import junit.framework.TestCase;
import model.ILambda;
import sysModel.ICmdFactory;
import sysModel.ISecurityAdapter;
import sysModel.env.*;
import sysModel.fish.*;
import sysModel.parser.Lexer;

import java.awt.*;
import java.io.PrintWriter;

/**
 * Test cases for AFish.
 *
 * @author Mathias Ricken
 */
public class Test_Fish extends TestCase {
    private IBlockedCommand _dummyB;
    private IOpenCommand _dummyO;

    private class TestFish extends AFish {
        protected void move() {
            // dummy
        }

        public void paint(Graphics2D g, Component comp) {
            // dummy
        }

        public void age() {
            super.age();
        }

        public TestFish(Color c) {
            super(c, new IFishDisplay() {
                public void draw(Graphics2D g, Component comp, Color fishColor) {
                }
            });
        }
    }

    private ICmdFactory _cmdFactory;
    private ISecurityAdapter _sm;
    private TestFish _fish;
    private TestGlobalEnv _env;
    private AGlobalEnv.ALocalEnv _localEnv;

    private static final ILambda _notify = new ILambda() {
        public Object apply(Object param) {
            return "notifyCmd";
        }
    };
    private static final ILambda _delete = new ILambda() {
        public Object apply(Object param) {
            return "deleteCmd";
        }
    };
    private static final ILambda _add = new ILambda() {
        public Object apply(Object param) {
            return "addCmd";
        }
    };

    private final class TestGlobalEnv extends AGlobalEnv {
        public TestGlobalEnv(ICmdFactory cmdFactory, ISecurityAdapter sm) {
            super(cmdFactory, sm);
        }

        protected ILambda editFish(AGlobalEnv.ALocalEnv localEnv, IFishFactory fishFactory, int button) {
            return null;
        }

        protected void addFishToInternalData(AGlobalEnv.ALocalEnv localEnv, AFish fish) {
        }

        protected void removeFishFromInternalData(AGlobalEnv.ALocalEnv localEnv) {
        }

        protected AGlobalEnv parseEnvironment(Lexer l) {
            return null;
        }

        protected void parseFish(Lexer l) {
        }

        public AGlobalEnv.ALocalEnv makeLocalEnv(Point.Double p) {
            return new AGlobalEnv.ALocalEnv() {
                void checkFish(AFish fish) {
                    if (fish != _fish) {
                        throw new IllegalArgumentException("Wrong fish!");
                    }
                }

                public Object tryMoveFwd(AFish fish, IBlockedCommand blockedCmd, IOpenCommand openCmd) {
                    checkFish(fish);
                    throw new RuntimeException("tryMoveFwd called");
                }

                public Object tryBreedFwd(AFish fish, IBlockedCommand blockedCmd, IOpenCommand openCmd) {
                    checkFish(fish);
                    throw new RuntimeException("tryBreedFwd called");
                }

                public void drawFish(AFish fish, Graphics2D g, Component comp) {
                    checkFish(fish);
                    throw new RuntimeException("drawFish called");
                }

                public void turnRight(AFish fish, double radians) {
                    checkFish(fish);
                    throw new RuntimeException("turnRight called, radians=" + radians);
                }

                public void removeFish(AFish fish) {
                    checkFish(fish);
                    throw new RuntimeException("removeFish called");
                }

                public Object execute(AGlobalEnv.ILocalEnvVisitor visitor, Object param) {
                    throw new RuntimeException("execute called");
                }

                public void setState(ILocalEnvState state) {
                }

                protected ILambda makeMoveLambda(AGlobalEnv.ALocalEnv le) {
                    return null;
                }

                protected AGlobalEnv.ALocalEnv makeMoveFwdLocalEnv() {
                    return null;
                }
            };
        }

        public AEnvFactory makeEnvFactory() {
            return null;
        }

        protected void printHeader(PrintWriter pw) {
        }

        public Dimension getDisplaySize() {
            return null;
        }

        public void returnHome(IScrollAdapter sa) {
        }

        public Point.Double getViewPosition(Point.Double pos) {
            return null;
        }

        public Point.Double getPanDelta(Point.Double delta) {
            return null;
        }

        public ILambda getToolTipText(Point.Double p) {
            return null;
        }
    }

    public void setUp() throws Exception {
        super.setUp();
        _fish = new TestFish(Color.RED);

        _cmdFactory = new ICmdFactory() {
            public ILambda makeNotifyCmd(ILambda lambda) {
                return _notify;
            }

            public ILambda makeDeleteCmd(AGlobalEnv.ALocalEnv env) {
                return _delete;
            }

            public ILambda makeAddCmd(AFish fish) {
                return _add;
            }
        };
        _sm = new ISecurityAdapter() {
            public void setProtected(boolean _protected) {
            }
            public ThreadGroup getFishThreadGroup() {
                return null;
            }
            public ClassLoader getClassLoader() {
                return null;
            }
            public void handleException(Throwable t) {
            }
        };

        _env = new TestGlobalEnv(_cmdFactory, _sm);

        _localEnv = _env.makeLocalEnv(new Point.Double(0, 0));
        _dummyB = new IBlockedCommand() {
            public Object apply(Object param) {
                return null;
            }
        };
        _dummyO = new IOpenCommand() {
            public Object apply(Object param) {
                return null;
            }
        };
        _fish.setLocalEnvironment(_localEnv);
    }

    /**
     * Test fish to local environment delegation for tryMoveFwd.
     */
    public void testTryMoveFwd() {
        try {
            _fish.tryMoveFwd(_dummyB, _dummyO);
            fail("Error in delegation.");
        }
        catch (RuntimeException e) {
            if (!"tryMoveFwd called".equals(e.getMessage())) {
                fail("Wrong method called.");
            }
        }
    }

    /**
     * Test fish to local environment delegation for tryBreedFwd.
     */
    public void testTryBreedFwd() {
        try {
            _fish.tryBreedFwd(_dummyB, _dummyO);
            fail("Error in delegation.");
        }
        catch (RuntimeException e) {
            if (!"tryBreedFwd called".equals(e.getMessage())) {
                fail("Wrong method called.");
            }
        }
    }

    /**
     * Test fish to local environment delegation for draw.
     */
    public void testDraw() {
        try {
            _fish.draw(null, null);
            fail("Error in delegation.");
        }
        catch (RuntimeException e) {
            if (!"drawFish called".equals(e.getMessage())) {
                fail("Wrong method called.");
            }
        }
    }

    /**
     * Test fish to local environment delegation for turnRight.
     */
    public void testTurnRight() {
        try {
            _fish.turnRight(3);
            fail("Error in delegation.");
        }
        catch (RuntimeException e) {
            if (!"turnRight called, radians=3.0".equals(e.getMessage())) {
                fail("Wrong method called. " + e);
            }
        }
    }

    /**
     * Test fish to local environment delegation for turnLeft.
     */
    public void testTurnLeft() {
        try {
            _fish.turnLeft(4.5);
            fail("Error in delegation.");
        }
        catch (RuntimeException e) {
            if (!"turnRight called, radians=-4.5".equals(e.getMessage())) {
                fail("Wrong method called. " + e);
            }
        }
    }

    /**
     * Test fish to local environment delegation for age.
     */
    public void testDie() {
        _fish.setProbOfDying(2);
        try {
            _fish.die();
            fail("Error in delegation.");
        }
        catch (RuntimeException e) {
            if (!"removeFish called".equals(e.getMessage())) {
                fail("Wrong method called.");
            }
        }
    }
}
