/**
 * Closed parenthesis token singleton
 *
 * @author  Mathias Ricken
 */
package sysModel.parser;

/**
 * Closing parenthesis token.
 *
 * @author Mathias Ricken
 */
public final class CloseToken implements IToken {
    /**
     * Singleton instance.
     */
    private static CloseToken _instance;

    /**
     * Return singleton instance.
     *
     * @return instance
     */
    public static synchronized CloseToken instance() {
        if (null == _instance) {
            _instance = new CloseToken();
        }
        return _instance;
    }

    /**
     * Private singleton constructor.
     */
    private CloseToken() {
    }

    /**
     * Execute visitor.
     *
     * @param v visitor
     * @return visitor-specific return value
     */
    public Object execute(ITokenVisitor v) {
        return v.closeCase();
    }
}

