/**
 * Comma token singleton
 *
 * @author  Mathias Ricken
 */
package sysModel.parser;

/**
 * Comma    token.
 *
 * @author Mathias Ricken
 */
public final class CommaToken implements IToken {
    /**
     * Singleton instance.
     */
    private static CommaToken _instance;

    /**
     * Return singleton instance.
     *
     * @return instance
     */
    public static synchronized CommaToken instance() {
        if (null == _instance) {
            _instance = new CommaToken();
        }
        return _instance;
    }

    /**
     * Private singleton constructor.
     */
    private CommaToken() {
    }

    /**
     * Execute visitor.
     *
     * @param v visitor
     * @return visitor-specific return value
     */
    public final Object execute(ITokenVisitor v) {
        return v.commaCase();
    }
}

