/**
 * End of stream token singleton
 *
 * @author  Mathias Ricken
 */
package sysModel.parser;

/**
 * End of stream token.
 *
 * @author Mathias Ricken
 */
public final class EndOfStreamToken implements IToken {
    /**
     * Singleton instance.
     */
    private static EndOfStreamToken _instance;

    /**
     * Return singleton instance.
     *
     * @return instance
     */
    public static synchronized EndOfStreamToken instance() {
        if (null == _instance) {
            _instance = new EndOfStreamToken();
        }
        return _instance;
    }

    /**
     * Private singleton constructor.
     */
    private EndOfStreamToken() {
    }

    /**
     * Execute visitor.
     *
     * @param v visitor
     * @return visitor-specific return value
     */
    public Object execute(ITokenVisitor v) {
        return v.endCase();
    }
}

