package sysModel.parser;

/**
 * Token visitor.
 *
 * @author Mathias Ricken
 */
public interface ITokenVisitor {
    /**
     * Case to be called if end of file is reached.
     *
     * @return visitor-specific return value
     */
    public Object endCase();

    /**
     * Case to be called if a word is read.
     *
     * @param word word
     * @return visitor-specific return value
     */
    public Object wordCase(String word);

    /**
     * Case to be called if a number is read.
     *
     * @param num number
     * @return visitor-specific return value
     */
    public Object numCase(double num);

    /**
     * Case to be called if an open parenthesis is read.
     *
     * @return visitor-specific return value
     */
    public Object openCase();

    /**
     * Case to be called if a closed parenthesis is read.
     *
     * @return visitor-specific return value
     */
    public Object closeCase();

    /**
     * Case to be called if a comma is read.
     *
     * @return visitor-specific return value
     */
    public Object commaCase();
}
