package sysModel.parser;

import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;

/**
 * Wrapper around StreamTokenizer.
 *
 * @author Mathias Ricken
 */
public class Lexer {
    /**
     * Stream tokenizer.
     */
    final StreamTokenizer _tok;

    /**
     * Make a new parser.
     *
     * @param filename file to lex
     * @throws IOException
     */
    public Lexer(String filename) throws IOException {
        _tok = new StreamTokenizer(new FileReader(filename));

        _tok.wordChars(0, 255);
        _tok.ordinaryChars(0, ' ');
        _tok.whitespaceChars(0, ' ');
        _tok.ordinaryChar('(');
        _tok.ordinaryChar(')');
        _tok.parseNumbers();
        _tok.wordChars('.', '.');
        _tok.ordinaryChar(',');
        _tok.eolIsSignificant(false);
    }

    /**
     * Get the next token.
     *
     * @return next token
     */
    public IToken nextToken() {
        try {
            switch (_tok.nextToken()) {
                case StreamTokenizer.TT_WORD:
                    {
                        return new WordToken(_tok.sval);
                    }
                case StreamTokenizer.TT_NUMBER:
                    {
                        return new NumberToken(_tok.nval);
                    }
                case '(':
                    {
                        return OpenToken.instance();
                    }
                case ')':
                    {
                        return CloseToken.instance();
                    }
                case ',':
                    {
                        return CommaToken.instance();
                    }
                case StreamTokenizer.TT_EOF:
                    {
                        return EndOfStreamToken.instance();
                    }
                default:
                    {
                        throw new ParserException("Invalid token");
                    }
            }
        }
        catch (IOException e) {
            throw new ParserException(e.toString(), e);
        }
    }
}
