package sysModel.parser;

import sysModel.ICmdFactory;
import sysModel.ISecurityAdapter;
import sysModel.env.AGlobalEnv;

import java.lang.reflect.Constructor;
import java.io.IOException;

/**
 * Parser class.
 *
 * @author Mathias Ricken
 */
public class Parser {
    /**
     * Invoke the parser and recreate a global environment from a file.
     *
     * @param filename        name of file
     * @param factory         factory to use for creation
     * @param securityAdapter security adapter in use
     * @return global environment
     */
    public static AGlobalEnv parse(String filename, final ICmdFactory factory, final ISecurityAdapter securityAdapter) {
        try {
            final Lexer l = new Lexer(filename);

            return (AGlobalEnv) l.nextToken().execute(new DefaultTokenVisitor() {
                public Object defaultCase() {
                    throw new ParserException("Invalid token");
                }

                public Object wordCase(String className) {
                    // read class name
                    try {
                        Class envClass = Class.forName(className);
                        Constructor envCtor = envClass.getConstructor(new Class[]{ICmdFactory.class, ISecurityAdapter.class});
                        AGlobalEnv env = (AGlobalEnv) envCtor.newInstance(new Object[]{factory, securityAdapter});
                        return env.parse(l);
                    }
                    catch (Exception e) {
                        throw new ParserException(e.toString(),e);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new ParserException(e.toString(),e);
        }
    }
}
