/**
 * Word token
 *
 * @author  Mathias Ricken
 */
package sysModel.parser;

/**
 * Word token.
 *
 * @author Mathias Ricken
 */
public class WordToken implements IToken {
    /**
     * Word.
     */
    private final String _word;

    /**
     * Make a new word token.
     *
     * @param w word
     */
    public WordToken(String w) {
        _word = w;
    }

    /**
     * Execute visitor.
     *
     * @param v visitor
     * @return visitor-specific return value
     */
    public Object execute(ITokenVisitor v) {
        return v.wordCase(_word);
    }
}

