#include "analysis/pragmainfo.h"

PragmaInfo::PragmaInfo(const std::string value, unsigned offset)
    : value_(value), offset_(offset) { }

std::string PragmaInfo::value() const
{
    return value_;
}

unsigned PragmaInfo::offset() const
{
    return offset_;
}

bool PragmaInfo::operator<(const PragmaInfo& other) const
{
    if (offset_ == other.offset_)
        return (value_.compare(other.value_) < 0);
    return (offset_ < other.offset_);
}
