#ifndef AAP_PRAGMAINFO_H
#define AAP_PRAGMAINFO_H

#include <string>

/// Represents information that should be injected into output source code in
/// the form of a #pragma. Each pragma comprises a string (without the initial
/// #pragma) and an offset relative to the object itself.
class PragmaInfo
{
public:
    PragmaInfo(const std::string, unsigned offset = 0);

    std::string value() const;
    unsigned offset() const;

    /// Returns true if this should be output earlier than the given argument.
    bool operator<(const PragmaInfo&) const;

private:
    std::string value_;
    unsigned offset_;
};

#endif
