//===----------------------------------------------------------------------===//
//
//                    The PACE Application Aware Partitioner
//
// Copyright (C) 2009 - 2010, ET International, Inc. All rights reserved.
//
// The information and source code contained herein is the exclusive property
// of ET International, Inc. and may not be disclosed, examined or reproduced
// in whole or in part without explicit written authorization from the company.
//
// This software was produced under a U.S. Government contract with the Air
// Force Research Lab. The U.S. Government is licensed to use, reproduce,
// modify, and distribute this software for use within the U.S. Government.
// These rights are equivalent to:
// GOVERNMENT PURPOSE RIGHTS, CONTRACT: F33615-09-C-7915
//
//===----------------------------------------------------------------------===//

#include "ast/aapaction.h"
#include "ast/aapconsumer.h"
#include "analysis/arraypadding.h"
#include "sourcefile.h"

#include "clang/Basic/SourceManager.h"
#include "clang/AST/TypeLoc.h"

#include "llvm/Support/Debug.h"

using namespace clang;
using namespace aap;

FrontendPluginRegistry::Add<AAPAction>
X("AAP", "generate AAP source objects");

SourceFile* AAPAction::sourceFile_ = NULL;

ASTConsumer*
AAPAction::CreateASTConsumer(CompilerInstance&, llvm::StringRef) {
  return new AAPConsumer();
}

void
AAPAction::setFile (SourceFile& file)
{
  sourceFile_ = &file;
}

SourceFile&
AAPAction::getFile(void)
{
  return *sourceFile_;
}
