//===------------------------------------------------------------*- C++ -*-===//
//
//                    The PACE Application Aware Partitioner
//
// Copyright (C) 2009 - 2010, ET International, Inc. All rights reserved.
//
// The information and source code contained herein is the exclusive property
// of ET International, Inc. and may not be disclosed, examined or reproduced
// in whole or in part without explicit written authorization from the company.
//
// This software was produced under a U.S. Government contract with the Air
// Force Research Lab. The U.S. Government is licensed to use, reproduce,
// modify, and distribute this software for use within the U.S. Government.
// These rights are equivalent to:
// GOVERNMENT PURPOSE RIGHTS, CONTRACT: F33615-09-C-7915
//
//===----------------------------------------------------------------------===//

#ifndef AAP_AST_AAPACTION_H
#define AAP_AST_AAPACTION_H

#include <clang/Frontend/FrontendPluginRegistry.h>
#include <clang/AST/ASTConsumer.h>
#include <clang/AST/AST.h>

namespace aap {

class SourceFile;

/// Creates front end action for AAP.
class AAPAction : public clang::PluginASTAction {
public:
  static void setFile (SourceFile&);
  static SourceFile& getFile(void);

protected:
  /// Creates an AST consumer job to execute in front-end.
  clang::ASTConsumer *CreateASTConsumer(clang::CompilerInstance &CI,
                                        llvm::StringRef);

  bool ParseArgs (const clang::CompilerInstance&,
                  const std::vector< std::string >&) { return true; }

private:
  static SourceFile* sourceFile_;
};

} // namespace aap

#endif
