//===----------------------------------------------------------------------===//
//
//                    The PACE Application Aware Partitioner
//
// Copyright (C) 2009 - 2011, ET International, Inc. All rights reserved.
//
// The information and source code contained herein is the exclusive property
// of ET International, Inc. and may not be disclosed, examined or reproduced
// in whole or in part without explicit written authorization from the company.
//
// This software was produced under a U.S. Government contract with the Air
// Force Research Lab. The U.S. Government is licensed to use, reproduce,
// modify, and distribute this software for use within the U.S. Government.
// These rights are equivalent to:
// GOVERNMENT PURPOSE RIGHTS, CONTRACT: F33615-09-C-7915
//
//===----------------------------------------------------------------------===//

#include "ast/aapaddinfoaction.h"
#include "ast/aapaddinfoconsumer.h"
#include "sourcefile.h"

#include "llvm/Support/Debug.h"

using namespace clang;
using namespace aap;

FrontendPluginRegistry::Add<AAPAddInfoAction>
Y("AAPInfo", "Add additional attributes");

SourceFile* AAPAddInfoAction::sourceFile_ = NULL;

ASTConsumer*
AAPAddInfoAction::CreateASTConsumer(CompilerInstance&, llvm::StringRef) {
    return new AAPAddInfoConsumer();
}

void
AAPAddInfoAction::setFile (SourceFile& file)
{
    sourceFile_ = &file;
}

SourceFile&
AAPAddInfoAction::getFile(void)
{
    return *sourceFile_;
}
