//===------------------------------------------------------------*- C++ -*-===//
//
//                    The PACE Application Aware Partitioner
//
// Copyright (C) 2009 - 2011, ET International, Inc. All rights reserved.
//
// The information and source code contained herein is the exclusive property
// of ET International, Inc. and may not be disclosed, examined or reproduced
// in whole or in part without explicit written authorization from the company.
//
// This software was produced under a U.S. Government contract with the Air
// Force Research Lab. The U.S. Government is licensed to use, reproduce,
// modify, and distribute this software for use within the U.S. Government.
// These rights are equivalent to:
// GOVERNMENT PURPOSE RIGHTS, CONTRACT: F33615-09-C-7915
//
//===----------------------------------------------------------------------===//

#ifndef AAP_AST_AAPADDINFOCONSUMER_H
#define AAP_AST_AAPADDINFOCONSUMER_H

#include "clang/Frontend/FrontendPluginRegistry.h"
#include "clang/Sema/SemaConsumer.h"

namespace aap {

class AttrInfo;

/// Processes AST of the translation unit (file)
class AAPAddInfoConsumer : public clang::SemaConsumer {
public:
    /// Handles the ASTs after entire translation unit has been parsed.
    virtual void HandleTranslationUnit(clang::ASTContext&);

protected:
    /// Handles parsed function declaration and definition.
    int HandleFunctionDecl(const clang::FunctionDecl*);
    /// Handles statements.
    void HandleStmt (AttrInfo *MyInfo, const clang::Stmt*);
    /// Handles expressions which modify variables
    void HandleLHSExpr(AttrInfo *MyInfo, const clang::Expr*);

private:
    clang::SourceManager* sourceManager;
};

} // namespace aap

#endif
