//===------------------------------------------------------------*- C++ -*-===//
//
//                    The PACE Application Aware Partitioner
//
// Copyright (C) 2009 - 2011, ET International, Inc. All rights reserved.
//
// The information and source code contained herein is the exclusive property
// of ET International, Inc. and may not be disclosed, examined or reproduced
// in whole or in part without explicit written authorization from the company.
//
// This software was produced under a U.S. Government contract with the Air
// Force Research Lab. The U.S. Government is licensed to use, reproduce,
// modify, and distribute this software for use within the U.S. Government.
// These rights are equivalent to:
// GOVERNMENT PURPOSE RIGHTS, CONTRACT: F33615-09-C-7915
//
//===----------------------------------------------------------------------===//

#ifndef AAP_AST_AAPCONSUMER_H
#define AAP_AST_AAPCONSUMER_H

#include "clang/Frontend/FrontendPluginRegistry.h"
#include "clang/AST/ASTConsumer.h"
#include "sourceobj.h"

namespace aap {

class SourceFile;

/// Processes AST of the translation unit (file)
class AAPConsumer : public clang::ASTConsumer {
public:
  /// Handles the ASTs after entire translation unit has been parsed.
  virtual void HandleTranslationUnit(clang::ASTContext&);

protected:
  /// Handles parsed function declaration and definition.
  void HandleFunctionDecl(const clang::FunctionDecl*);
  /// Handles parsed global variables.
  void HandleVarDecl(const clang::VarDecl*);
  /// Handles parsed enum declaration and definition.
  void HandleEnumDecl(const clang::EnumDecl*);
  /// Handles parsed structure/union declaration and definition.
  void HandleRecordDecl(const clang::RecordDecl*);
  /// Handles parsed typedef declaration.
  void HandleTypedefDecl(const clang::TypedefDecl *);
  /// Handles statements and add dependencies.
  void HandleStmt(SourceObjRef, const clang::Stmt *);
  /// Handles different types and add dependencies.
  void HandleDifferentTypes(SourceObjRef, clang::Type *);
  /// Handles structure/union fields and add dependencies.
  void HandleRecordFields(SourceObjRef, const clang::RecordDecl*);
  /// Handles enum constants and add dependencies.
  void HandleEnumConsts(SourceObjRef, const clang::EnumDecl*);
  /// Handles function parameters and add dependencies.
  void HandleFunctionParams(SourceObjRef, const clang::FunctionDecl*);
  /// Specialized array handling used when array padding analysis is active.
  void HandleArrayExpr(SourceObjRef, const clang::ArraySubscriptExpr*);
  /// Handles references to variables within function bodies.
  void HandleVarDeclRef(SourceObjRef, const clang::VarDecl*);

private:
  clang::SourceManager* sourceManager_;
  /// Maps each global declaration onto a source object.
  std::map<const clang::NamedDecl*,SourceObjRef> ObjectsMap;
  /// The current function (if applicable).
  SourceObjRef function_;
};

} // namespace aap

#endif
