//===------------------------------------------------------------*- C++ -*-===//
//
//                    The PACE Application Aware Partitioner
//
// Copyright (C) 2009 - 2010, ET International, Inc. All rights reserved.
//
// The information and source code contained herein is the exclusive property
// of ET International, Inc. and may not be disclosed, examined or reproduced
// in whole or in part without explicit written authorization from the company.
//
// This software was produced under a U.S. Government contract with the Air
// Force Research Lab. The U.S. Government is licensed to use, reproduce,
// modify, and distribute this software for use within the U.S. Government.
// These rights are equivalent to:
// GOVERNMENT PURPOSE RIGHTS, CONTRACT: F33615-09-C-7915
//
//===----------------------------------------------------------------------===//
//
// AAP Diagnostic Client
//
// This class implements a simple diagnostic client that ignores all
// diagnostics so that the AAP output is quiet when parsing fails
//
//===----------------------------------------------------------------------===//

#include "clang/Basic/Diagnostic.h"

namespace aap
{

/// \brief Simple diagnostic client that ignores all warnings and errors.
///
/// An implementation of the clang::DiagnosticClient that silently ignores
/// all errors. The AAP uses this to reduce output duing execution.
class AAPDiagnosticClient : public clang::DiagnosticClient
{
public:
  virtual void HandleDiagnostic (clang::Diagnostic::Level,
                                 const clang::DiagnosticInfo&);
};

} // namespace aap
