//===------------------------------------------------------------*- C++ -*-===//
//
//                    The PACE Application Aware Partitioner
//
// Copyright (C) 2009 - 2010, ET International, Inc. All rights reserved.
//
// The information and source code contained herein is the exclusive property
// of ET International, Inc. and may not be disclosed, examined or reproduced
// in whole or in part without explicit written authorization from the company.
//
// This software was produced under a U.S. Government contract with the Air
// Force Research Lab. The U.S. Government is licensed to use, reproduce,
// modify, and distribute this software for use within the U.S. Government.
// These rights are equivalent to:
// GOVERNMENT PURPOSE RIGHTS, CONTRACT: F33615-09-C-7915
//
//===----------------------------------------------------------------------===//

#ifndef APP_FUNCTIONPARSER_BUILDOPTIONFACTORY_H
#define APP_FUNCTIONPARSER_BUILDOPTIONFACTORY_H

#include <xercesc/sax2/DefaultHandler.hpp>

#include <llvm/Support/CommandLine.h>
#include "config/llvm.h"

#include <map>
#include <string>

namespace aap {

class BuildOptions;

/// Factory methods for BuildOptions
class BuildOptionFactory : public xercesc::DefaultHandler
{
public:
    /// Command line argument specifying the build file to use.
    static llvm::cl::opt<llvm::sys::Path, false,
                         llvm::cl::parser<std::string> > file;

    /// Parses the file at the given path to construct BuildOptions.
    std::map<std::string, BuildOptions>
    parse(const llvm::sys::Path& path = file);

private:
    // Internal mapping of files to their build options.
    std::map<std::string,BuildOptions> options_;

    std::string   current_file_;
    BuildOptions* current_options_;

    //sax ContentHandler methods
    /// Handles the end of an XML element during parsing.
    void endElement(const XMLCh*, const XMLCh*, const XMLCh*);
    /// Handles the start of an XML element during parsing.
    void startElement(const XMLCh*, const XMLCh*, 
                      const XMLCh*, const xercesc::Attributes&);

    //sax ErrorHandler methods
    /// Handles a warning raised by the SAX parser.
    void warning(const xercesc::SAXParseException&);
    /// Handles an error raised by the SAX parser.
    void error(const xercesc::SAXParseException&);
    /// Handles a fatal error raised by the SAX parser.
    void fatalError(const xercesc::SAXParseException&);
};

} // namespace aap

#endif
