//===----------------------------------------------------------------------===//
//
//                    The PACE Application Aware Partitioner
//
// Copyright (C) 2009 - 2010, ET International, Inc. All rights reserved.
//
// The information and source code contained herein is the exclusive property
// of ET International, Inc. and may not be disclosed, examined or reproduced
// in whole or in part without explicit written authorization from the company.
//
// This software was produced under a U.S. Government contract with the Air
// Force Research Lab. The U.S. Government is licensed to use, reproduce,
// modify, and distribute this software for use within the U.S. Government.
// These rights are equivalent to:
// GOVERNMENT PURPOSE RIGHTS, CONTRACT: F33615-09-C-7915
//
//===----------------------------------------------------------------------===//

#include "buildoptions.h"
#include "buildoptionfactory.h"

using namespace std;
using namespace aap;

/**
  BuildOptions are parsed from an input file with a series of XML entries like
  the one below. Each file may contain some number of compiler command line
  options. The parsing process will determine whether the option is intended
  for the pre-processor, compiler, or linker.

 <file path="/tmp/file.c">
   <option name="-D" arg="TEST" />
 </file>

**/

BuildOptions BuildOptions::global_;

const vector<string>
BuildOptions::compileFlags (void) const
{
    return compileFlags_;
}

const std::vector<std::string>
BuildOptions::linkerFlags (void) const
{
    return linkerFlags_;
}

const vector<string>
BuildOptions::preprocFlags (void) const
{
    return preprocFlags_;
}

vector<string>
BuildOptions::globalCompileFlags (void)
{
    return global_.compileFlags();
}

vector<string>
BuildOptions::globalLinkerFlags  (void)
{
    return global_.linkerFlags();
}

vector<string>
BuildOptions::globalPreprocFlags (void)
{
    return global_.preprocFlags();
}

/// The given name should represent the actual command line option (such as
/// -D). The option is automatically associated with the C pre-processor, the
/// linker, or the compiler.
void
BuildOptions::addOption (const string &name, const string &value)
{
    string flag = name;
    flag.append (value);

    if (name.compare ("-D") == 0)
        preprocFlags_.push_back (flag);
    else if (name.compare ("-I") == 0)
        preprocFlags_.push_back (flag);
    else if (name.compare ("-l") == 0)
        linkerFlags_.push_back (flag);
    else
        compileFlags_.push_back (flag);
}

void
BuildOptions::importOptions (const BuildOptions& options)
{
    preprocFlags_.insert (preprocFlags_.end(),
                          options.preprocFlags_.begin(),
                          options.preprocFlags_.end());
    compileFlags_.insert (compileFlags_.end(),
                          options.compileFlags_.begin(),
                          options.compileFlags_.end());
    linkerFlags_.insert (linkerFlags_.end(),
                          options.linkerFlags_.begin(),
                          options.linkerFlags_.end());
}
