//===------------------------------------------------------------*- C++ -*-===//
//
//                    The PACE Application Aware Partitioner
//
// Copyright (C) 2009 - 2010, ET International, Inc. All rights reserved.
//
// The information and source code contained herein is the exclusive property
// of ET International, Inc. and may not be disclosed, examined or reproduced
// in whole or in part without explicit written authorization from the company.
//
// This software was produced under a U.S. Government contract with the Air
// Force Research Lab. The U.S. Government is licensed to use, reproduce,
// modify, and distribute this software for use within the U.S. Government.
// These rights are equivalent to:
// GOVERNMENT PURPOSE RIGHTS, CONTRACT: F33615-09-C-7915
//
//===----------------------------------------------------------------------===//

#ifndef AAP_FUNCTIONPARSER_BUILDOPTIONS_H
#define AAP_FUNCTIONPARSER_BUILDOPTIONS_H

#include <map>
#include <string>
#include <vector>

namespace aap {

class BuildOptionFactory;

/// Represents the command line options used to build a source file.

/// Options are automatically divided into preprocessing, compilation, and
/// linking flags. Flags are maintained in order to preserve any significance to
/// the compiler command-line order.
class BuildOptions
{
public:
    /// Returns the compilation flags.
    const std::vector<std::string> compileFlags (void) const;
    /// Returns the linker flags.
    const std::vector<std::string> linkerFlags  (void) const;
    /// Returns the C pre-processor flags.
    const std::vector<std::string> preprocFlags (void) const;

    /// Returns the compilation flags used for all files.
    static std::vector<std::string> globalCompileFlags (void);
    /// Returns the linker flags used for all files.
    static std::vector<std::string> globalLinkerFlags  (void);
    /// Returns the C pre-processor flags used for all files.
    static std::vector<std::string> globalPreprocFlags (void);

    /// Adds the given option and value to the set of build options. 
    void addOption (const std::string&, const std::string&);
    /// Adds all of the options in the given set.
    void importOptions (const BuildOptions&);

    friend class BuildOptionFactory;

private:
    std::vector<std::string> preprocFlags_;
    std::vector<std::string> compileFlags_;
    std::vector<std::string> linkerFlags_;

    static BuildOptions global_;

};

} // namespace aap

#endif
