//===------------------------------------------------------------*- C++ -*-===//
//
//                    The PACE Application Aware Partitioner
//
// Copyright (C) 2009 - 2010, ET International, Inc. All rights reserved.
//
// The information and source code contained herein is the exclusive property
// of ET International, Inc. and may not be disclosed, examined or reproduced
// in whole or in part without explicit written authorization from the company.
//
// This software was produced under a U.S. Government contract with the Air
// Force Research Lab. The U.S. Government is licensed to use, reproduce,
// modify, and distribute this software for use within the U.S. Government.
// These rights are equivalent to:
// GOVERNMENT PURPOSE RIGHTS, CONTRACT: F33615-09-C-7915
//
//===----------------------------------------------------------------------===//

#ifndef AAP_COMMUNITY_H
#define AAP_COMMUNITY_H

#include <map>
#include "graphutils.h"
#include "partitioner.h"

namespace aap {

/// Partitioning Using Shortest Paths Betweenness

/// Partition a graph into subgraphs according to the method proposed in 
/// "Finding and evaluating community structure in networks", Physical Review E
/// 69. The method is generalized onto weighted graphs.
class Community : public Partitioner
{
public:
  /// Partition graph using Shortest Paths Betweenness algorithm
  Agraph_t* partition (Agraph_t *);
  Community(void);
private:
  /// Partition the subgraph
  void SubgraphPartition (Agraph_t *);
  /// Allocate Required matrices
  void InitializeVectors (Agraph_t *);
  /// Calculate All Pairs shortest paths
  Agedge_t* SubgraphShortestPaths (Agraph_t *);
  /// Calculates shourtest paths from a source to other destinations
  void SingleShortestPaths (Agraph_t *, int);
  /// Free allocated vectors
  void FreeVectors (void);

  Agraph_t *RootGraph;
  /// Number of Nodes in Subgraph
  int NodeNumber;
  /// Nodes and their integer correspondance
  std::map<Agnode_t*,int> NodesMap;
  /// Points to nodes in subgraph
  Agnode_t **Nodes;
};

} // namespace aap

#endif // AAP_COMMUNITY_H
