//===------------------------------------------------------------*- C++ -*-===//
//
//                    The PACE Application Aware Partitioner
//
// Copyright (C) 2009 - 2010, ET International, Inc. All rights reserved.
//
// The information and source code contained herein is the exclusive property
// of ET International, Inc. and may not be disclosed, examined or reproduced
// in whole or in part without explicit written authorization from the company.
//
// This software was produced under a U.S. Government contract with the Air
// Force Research Lab. The U.S. Government is licensed to use, reproduce,
// modify, and distribute this software for use within the U.S. Government.
// These rights are equivalent to:
// GOVERNMENT PURPOSE RIGHTS, CONTRACT: F33615-09-C-7915
//
//===----------------------------------------------------------------------===//

#ifndef AAP_LIMBO_H
#define AAP_LIMBO_H

#include <map>
#include "graphutils.h"
#include "partitioner.h"

namespace aap {

/// LIMBO Algorithm

/// Partition the graph into subgraphs using agglomerative method in paper
/// "Information-Theoretic Software Clustering",
/// IEEE Transactions on Software Engineering
class Limbo : public Partitioner
{
 public:
  /// Partition graph using LIMBO Algorithm
  Agraph_t* partition (Agraph_t *);
  Limbo (void);
  /// Combine subgraphs
  void CombinePartitions (Agraph_t *);   // Combine subgraphs

 private:
  void GraphPartition (void);
  /// Allocate Required matrices
  void InitializeMatrices (Agraph_t *);
  /// Combine two Clusters
  void CombineClusters (int, int);
  /// Calculates information loss of two clusters
  double InformationLoss (int, int);
  /// Free allocated matrices
  void FreeMatrices (void);

  Agraph_t *RootGraph;
  /// Number of columns
  int NodeNumber;
  /// Original number of rows (partitions)
  int ClusterNumber;
  double **NrmMat;
  /// Probability Mass Function
  double *PMF;
  /// Consider current row or not
  bool *Use;
  bool **Neighbor;
  std::map<int,Agraph_t*> SubGraphMap;
};

} // namespace aap

#endif // AAP_LIMBO_H
