//===------------------------------------------------------------*- C++ -*-===//
//
//                    The PACE Application Aware Partitioner
//
// Copyright (C) 2009 - 2010, ET International, Inc. All rights reserved.
//
// The information and source code contained herein is the exclusive property
// of ET International, Inc. and may not be disclosed, examined or reproduced
// in whole or in part without explicit written authorization from the company.
//
// This software was produced under a U.S. Government contract with the Air
// Force Research Lab. The U.S. Government is licensed to use, reproduce,
// modify, and distribute this software for use within the U.S. Government.
// These rights are equivalent to:
// GOVERNMENT PURPOSE RIGHTS, CONTRACT: F33615-09-C-7915
//
//===----------------------------------------------------------------------===//

#ifndef AAP_RANDOMWALKS_H
#define AAP_RANDOMWALKS_H

#include <map>
#include "graphutils.h"
#include "partitioner.h"

namespace aap {

/// Partitioning using Random Walks betweenness

/// Partition a graph into subgraphs according to the method proposed in 
/// "Finding and evaluating community structure in networks", Physical Review E
/// 69. The method is generalized onto weighted graphs.
class RandomWalks : public Partitioner
{
public:
  /// Partition graph using Random Walks Betweenness Algorithm
  Agraph_t* partition (Agraph_t *);
  RandomWalks(void);

private:
  void SubgraphPartition (Agraph_t *);
  /// Allocate Required matrices
  void InitializeMatrices (Agraph_t *);
  /// Calculate Random Walks
  void SubgraphRandomWalks (int*,int*);
  void CalculateResult (double*,double*,double*,int);
  /// Free allocated matrices
  void FreeMatrices (void);

  Agraph_t *RootGraph;
  /// Number of Nodes in Subgraph
  int NodeNumber;
  double MaxWeight;
  /// Adjacency Matrix
  double *AdjMat;
  std::map<int,Agedge_t*> EdgeMap;
};

} // namespace aap

#endif // AAP_RANDOMWALKS_H
