//===----------------------------------------------------------------------===//
//
//                    The PACE Application Aware Partitioner
//
// Copyright (C) 2009 - 2010, ET International, Inc. All rights reserved.
//
// The information and source code contained herein is the exclusive property
// of ET International, Inc. and may not be disclosed, examined or reproduced
// in whole or in part without explicit written authorization from the company.
//
// This software was produced under a U.S. Government contract with the Air
// Force Research Lab. The U.S. Government is licensed to use, reproduce,
// modify, and distribute this software for use within the U.S. Government.
// These rights are equivalent to:
// GOVERNMENT PURPOSE RIGHTS, CONTRACT: F33615-09-C-7915
//
//===----------------------------------------------------------------------===//

#include <iostream>
#include <vector>

#include "graph/graphutils.h"
#include "graph/SloPrune.h"
#include "utils/options.h"

using namespace aap;

Agraph_t* SloPrune::partition (Agraph_t* Graph)
{
    unsigned int i,j;
    int NumPruned;
    double TotalWeight, CurWeight, Threshold;
    Agnode_t *Node, *Next;
    Agraph_t *Subgraph;
    std::vector<Agraph_t*> Subgraphs;
    std::vector<Agnode_t*> Nodes;

    Graph = agroot(Graph);
    TotalWeight = (double) GraphUtils::GraphWeight(Graph);
    Threshold = Options::pruneThreshold() * TotalWeight;
    NumPruned = 0;
    Node = agfstnode(Graph);
    while (Node != NULL) {
        Next = agnxtnode(Graph,Node);
        CurWeight = (double) GraphUtils::NodeWeight(Graph,Node);
        if (CurWeight < Threshold) {
            agdelnode(Graph,Node);
            NumPruned++;
        }
        Node = Next;
    }
    if (Options::verbose())
        std::cout << "Pruned (SLO) " << NumPruned << " nodes" << std::endl;
    if (NumPruned > 0) {
        for (Subgraph = agfstsubg(Graph); Subgraph != NULL;
             Subgraph = agnxtsubg(Subgraph))
            Subgraphs.push_back(Subgraph);
        for (i=0; i<Subgraphs.size(); i++) {
            Subgraph = Subgraphs[i];
            for (Node = agfstnode(Subgraph); Node != NULL;
                 Node = agnxtnode(Subgraph,Node))
                Nodes.push_back(Node);
            agdelsubg(Graph,Subgraph);
            Subgraph = GraphUtils::NewSubGraph(Graph,Options::rpuPrefix());
            for (j=0; j<Nodes.size(); j++) {
                Node = Nodes[i];
                if (agsubnode(Subgraph,Node,false) == NULL)
                    GraphUtils::MoveConnected(Node, Graph, Subgraph);
            }
            Nodes.clear();
        }
        Subgraphs.clear();
    }
    return Graph;
}
