//===------------------------------------------------------------*- C++ -*-===//
//
//                    The PACE Application Aware Partitioner
//
// Copyright (C) 2009 - 2010, ET International, Inc. All rights reserved.
//
// The information and source code contained herein is the exclusive property
// of ET International, Inc. and may not be disclosed, examined or reproduced
// in whole or in part without explicit written authorization from the company.
//
// This software was produced under a U.S. Government contract with the Air
// Force Research Lab. The U.S. Government is licensed to use, reproduce,
// modify, and distribute this software for use within the U.S. Government.
// These rights are equivalent to:
// GOVERNMENT PURPOSE RIGHTS, CONTRACT: F33615-09-C-7915
//
//===----------------------------------------------------------------------===//

#ifndef AAP_GRAPH_H
#define AAP_GRAPH_H

#include <graphviz/cdt.h>
#include <graphviz/cgraph.h>

#include "profiling/procedure.h"
// #include "profiling/hpcprocedure.h"
// #include "profiling/SloProcedure.h"

namespace aap {

// Data structures that are attached to libgraph elements (graphs, nodes, and
// edges) and made available during to graph construction and
// partitioning. Use the GraphUtils::getInfo functions to retrieve them.

/// AAP specific call-graph attributes.
typedef struct Agraphinfo_t
{
  Agrec_t header;               /// Default libgraph record.
  unsigned total_time;          /// Total program execution time. 
} Agraphinfo_t;

/// AAP specific call-graph node attributes.
typedef struct Agnodeinfo_t
{
  Agrec_t header;               /// Default libgraph record.
  unsigned retcnt;              /// HPC Toolkit RETCNT value.
  unsigned time;                /// HPC Toolkit WALLCLOCK value.
  unsigned staticSite;
  unsigned Depth;
  ProcedureRef procedure;       /// Associated profile procedure.
  Agraph_t* subg;
} Agnodeinfo_t;

/// AAP specific call-graph edge attributes.
typedef struct Agedgeinfo_t {
  Agrec_t header;               /// Default libgraph record.
  long calls;
  long reuse;
  long weight;
  int NumTaken; // Used for shortest paths betweenness calculation
} Agedgeinfo_t;

} // namespace aap

#endif
