//===------------------------------------------------------------*- C++ -*-===//
//
//                    The PACE Application Aware Partitioner
//
// Copyright (C) 2009 - 2010, ET International, Inc. All rights reserved.
//
// The information and source code contained herein is the exclusive property
// of ET International, Inc. and may not be disclosed, examined or reproduced
// in whole or in part without explicit written authorization from the company.
//
// This software was produced under a U.S. Government contract with the Air
// Force Research Lab. The U.S. Government is licensed to use, reproduce,
// modify, and distribute this software for use within the U.S. Government.
// These rights are equivalent to:
// GOVERNMENT PURPOSE RIGHTS, CONTRACT: F33615-09-C-7915
//
//===----------------------------------------------------------------------===//

#ifndef AAP_GRAPHUTILS_H
#define AAP_GRAPHUTILS_H

#include <limits.h>

#include <string>
#include <vector>

#include "graph/graph.h"
#include "validator.h"

namespace aap {

/// Helper functions for graph processing
namespace GraphUtils
{
    bool edge_compare (Agedge_t *e1, Agedge_t *e2);
    int NumLines (Agraph_t* graph);
    Agedge_t* find_min_edge (Agraph_t* graph);

    void moveNode  (Agnode_t* node, Agraph_t* from, Agraph_t* to);
    void move_tree (Agnode_t* root, Agraph_t* oldg, Agraph_t* newg);
    void remove_tree (Agraph_t* graph, Agnode_t* root);

    void MoveConnected (Agnode_t* root, Agraph_t* oldg, Agraph_t* newg);
    void MoveUndTree (Agnode_t* root, Agraph_t* oldg, Agraph_t* newg);

    void SetDepth (Agnode_t* Node, unsigned int Depth);
    unsigned int GetDepth (Agnode_t* Node);
    void CreateDepth (Agnode_t* Root, Agraph_t* Graph);

    Agnode_t* DestinedNode (Agnode_t* Source, Agedge_t* Edge);
    long NodeWeight (Agraph_t* Graph, Agnode_t* Node);
    long GraphWeight (Agraph_t* Graph);
    
    long tree_weight (Agraph_t* graph, Agnode_t* root);
    int tree_time (Agraph_t* graph, Agnode_t* root);

    void setLineCounts (Agraph_t* graph);

    void dump_graph (Agraph_t* graph, const std::string& file);

    Agnode_t* treeRoot (Agraph_t* subgraph);
    Agraph_t* NewSubGraph (Agraph_t *RootGraph, const std::string& prefix);

    void UpdateEdgeStyles (Agraph_t *Graph);
    double CalculateMQ (Agraph_t *Graph);
    double CalculateQ (Agraph_t *Graph);
    void MoveEdgesToSubgraphs (Agraph_t *Graph);

    Agraph_t* CombineSubgraphs (Agraph_t *Subgraph1, Agraph_t *Subgraph2,
                                const std::string& prefix);
    Agraph_t* MoveSubgraph (Agraph_t *Subgraph, const std::string& prefix);

    void DeleteGraph (Agraph_t* Graph);

    // Return the AAP information (as defined in graph.h) for an object
    Agraphinfo_t* getInfo (Agraph_t* graph);
    Agnodeinfo_t* getInfo (Agnode_t* node);
    Agedgeinfo_t* getInfo (Agedge_t* edge);

    // Convenience functions to create objects with the correct records
    Agedge_t* createEdge (Agraph_t* graph, Agnode_t* from, Agnode_t* to);
    Agnode_t* createNode (Agraph_t* graph, char* label);

    // Initialize the object with the necessary attributes
    void initializeGraph (Agraph_t* graph);
    void initializeNode  (Agnode_t* node, Agraph_t* subgraph);
}

} // namespace aap

#endif
