//===------------------------------------------------------------*- C++ -*-===//
//
//                    The PACE Application Aware Partitioner
//
// Copyright (C) 2009 - 2010, ET International, Inc. All rights reserved.
//
// The information and source code contained herein is the exclusive property
// of ET International, Inc. and may not be disclosed, examined or reproduced
// in whole or in part without explicit written authorization from the company.
//
// This software was produced under a U.S. Government contract with the Air
// Force Research Lab. The U.S. Government is licensed to use, reproduce,
// modify, and distribute this software for use within the U.S. Government.
// These rights are equivalent to:
// GOVERNMENT PURPOSE RIGHTS, CONTRACT: F33615-09-C-7915
//
//===----------------------------------------------------------------------===//

#ifndef AAP_MINCUT_H
#define AAP_MINCUT_H

#include "partitioner.h"

namespace aap {

/// A simple graph partitioner.

/// MinCut divides a call tree into subgraphs by cutting the lowest weight edge
/// (based on return counts).
///
/// See partitioner.h for further documentation.
class MinCut : public Partitioner
{
public:
    Agraph_t* partition (Agraph_t*);
};

} // namespace aap

#endif
