//===----------------------------------------------------------------------===//
//
//                    The PACE Application Aware Partitioner
//
// Copyright (C) 2009 - 2010, ET International, Inc. All rights reserved.
//
// The information and source code contained herein is the exclusive property
// of ET International, Inc. and may not be disclosed, examined or reproduced
// in whole or in part without explicit written authorization from the company.
//
// This software was produced under a U.S. Government contract with the Air
// Force Research Lab. The U.S. Government is licensed to use, reproduce,
// modify, and distribute this software for use within the U.S. Government.
// These rights are equivalent to:
// GOVERNMENT PURPOSE RIGHTS, CONTRACT: F33615-09-C-7915
//
//===----------------------------------------------------------------------===//

#include <limits.h>
#include <stdint.h>
#include <sys/wait.h>

#include <iostream>
#include <sstream>

#include "graph/graph.h"
#include "graph/graphutils.h"
#include "graph/mincut.h"
#include "graph/partitioner.h"
#include "graph/prune.h"
#include "graph/recombine.h"
#include "graph/Community.h"
#include "graph/RandomWalks.h"
#include "graph/Limbo.h"
#include "graph/SloPrune.h"
#include "utils/options.h"
#include "sourcefile.h"

using namespace std;
using namespace aap;
using namespace aap::GraphUtils;

Agraph_t*
Partitioner::partition (Agraph_t* graph)
{
    if (Options::pruneThreshold() > 0.0)  {
        if (agisdirected(graph)) {
            Prune prune;
            prune.partition (graph);
        }
        else {
            SloPrune prune;
            prune.partition(graph);
        }
        if (Options::keep_graph ())
            dump_graph(graph, Options::outPath() + "/aap.pruned.dot");
    }

    if ( (Options::partitioner() == Options::COMMUNITY)  ||
         (Options::partitioner() == Options::COMMUNLIMBO) )  {
        Community NewComm;
        graph = NewComm.partition(graph);
    }
    else if ( (Options::partitioner() == Options::RANDOMWALKS) ||
              (Options::partitioner() == Options::RANDOMLIMBO)  ) {
        RandomWalks RW;
        graph = RW.partition(graph);
    }
    else if (Options::partitioner() == Options::LIMBO) {
        Limbo LB;
        graph = LB.partition(graph);
    }
    else {
        MinCut cut;
        graph = cut.partition (graph);
        if (Options::partitioner() == Options::RECOMBINE) {
            Recombine recombine;
            graph = recombine.partition (graph);
        }
    }

    return graph;
}
