//===------------------------------------------------------------*- C++ -*-===//
//
//                    The PACE Application Aware Partitioner
//
// Copyright (C) 2009 - 2010, ET International, Inc. All rights reserved.
//
// The information and source code contained herein is the exclusive property
// of ET International, Inc. and may not be disclosed, examined or reproduced
// in whole or in part without explicit written authorization from the company.
//
// This software was produced under a U.S. Government contract with the Air
// Force Research Lab. The U.S. Government is licensed to use, reproduce,
// modify, and distribute this software for use within the U.S. Government.
// These rights are equivalent to:
// GOVERNMENT PURPOSE RIGHTS, CONTRACT: F33615-09-C-7915
//
//===----------------------------------------------------------------------===//

#ifndef AAP_PARTITION_H
#define AAP_PARTITION_H

#include <string>

#include <graphviz/cdt.h>
#include <graphviz/cgraph.h>

namespace aap {

/// Partitions a graph into subgraphs representing RPUs.
class Partitioner
{
public:
    // Partition the given graph. Assumes the graph contains some number of
    // subgraphs name according to Options::rpuPrefix (e.g. rpu0,rpu1 ... rpuN)
    // The resulting graph will have some number (typically more) subgraphs
    // similarly named (foo0 ... fooM).
    // The caller must dispose of the output graph, while this function owns
    // the input graph (which may be modified in place and handed back).
    virtual Agraph_t* partition (Agraph_t*);
};

} // namespace aap

#endif
