//===------------------------------------------------------------*- C++ -*-===//
//
//                    The PACE Application Aware Partitioner
//
// Copyright (C) 2009 - 2010, ET International, Inc. All rights reserved.
//
// The information and source code contained herein is the exclusive property
// of ET International, Inc. and may not be disclosed, examined or reproduced
// in whole or in part without explicit written authorization from the company.
//
// This software was produced under a U.S. Government contract with the Air
// Force Research Lab. The U.S. Government is licensed to use, reproduce,
// modify, and distribute this software for use within the U.S. Government.
// These rights are equivalent to:
// GOVERNMENT PURPOSE RIGHTS, CONTRACT: F33615-09-C-7915
//
//===----------------------------------------------------------------------===//

#ifndef AAP_RECOMBINE_H
#define AAP_RECOMBINE_H

#include "partitioner.h"
#include "validator.h"

namespace aap {

/// Recombine RPU subgraphs when the resulting subgraph is still small enough.

/// Because some graph partitioning systems (such as MinCut) use a greedy
/// algorithm, they may break off very small sub-graphs. Recombine does not
/// actually partition a graph, but rather attempts to fix-up a graph as a
/// post-processing setp.
/// See partitioner.h for further documentation.
class Recombine : public Partitioner
{
private:
    Validator   validator_;     // used to validate each cut

public:
    Agraph_t* partition (Agraph_t*);
};

} // namespace aap

#endif
