//===------------------------------------------------------------*- C++ -*-===//
//
//                    The PACE Application Aware Partitioner
//
// Copyright (C) 2009 - 2010, ET International, Inc. All rights reserved.
//
// The information and source code contained herein is the exclusive property
// of ET International, Inc. and may not be disclosed, examined or reproduced
// in whole or in part without explicit written authorization from the company.
//
// This software was produced under a U.S. Government contract with the Air
// Force Research Lab. The U.S. Government is licensed to use, reproduce,
// modify, and distribute this software for use within the U.S. Government.
// These rights are equivalent to:
// GOVERNMENT PURPOSE RIGHTS, CONTRACT: F33615-09-C-7915
//
//===----------------------------------------------------------------------===//
//
// Header file for structures which processes SLO database file
// and creates memory footprint.
//
//===----------------------------------------------------------------------===//

#ifndef AAP_SLODATABASE_H
#define AAP_SLODATABASE_H

#include <string>
#include <vector>
#include <map>

#include <llvm/Support/CommandLine.h>
#include "config/llvm.h"

#include "graph/graph.h"
#include "profiling/SloProcedure.h"
#include "sourceobj.h"

namespace aap {

class SloFile;
class SloReuse;

/// Parses Slo Memory footprint file
class SloDatabase
{
public:
  static llvm::cl::opt<llvm::sys::Path, false,
                       llvm::cl::parser<std::string> > profile;
  static llvm::cl::opt<llvm::sys::Path, false,
                       llvm::cl::parser<std::string> > sourceLocation;

  SloDatabase (const llvm::sys::Path& path=profile);
  ~SloDatabase (void);

  int ProcessBRD (const llvm::sys::Path& SourcePath = sourceLocation);
  void CreateGraph (void);
  void PrintBRD (void);
  Agraph_t* GetGraph (void);
  /// Includes Hpc Info to the graph
  void IncludeHpcInfo (Agraph_t*);
  void CreateInitialSubGraphs (void);

private:
  /// Memory footprint database
  llvm::sys::Path MemoryDatabase;
  int Offset;
  std::map<int,SloFile*> FileMap;
  std::vector<SloReuse*> MemoryReuse;
  int SubGraphID;
  Agraph_t* SloGraph;
};

} // namespace aap

#endif // AAP_SLODATABASE_H
