//===----------------------------------------------------------------------===//
//
//                    The PACE Application Aware Partitioner
//
// Copyright (C) 2009 - 2010, ET International, Inc. All rights reserved.
//
// The information and source code contained herein is the exclusive property
// of ET International, Inc. and may not be disclosed, examined or reproduced
// in whole or in part without explicit written authorization from the company.
//
// This software was produced under a U.S. Government contract with the Air
// Force Research Lab. The U.S. Government is licensed to use, reproduce,
// modify, and distribute this software for use within the U.S. Government.
// These rights are equivalent to:
// GOVERNMENT PURPOSE RIGHTS, CONTRACT: F33615-09-C-7915
//
//===----------------------------------------------------------------------===//

#include <iostream>
#include "SloProcedure.h"

using namespace aap;

SloProcedure::SloProcedure (const std::string& Name,
                            const std::string& FileName)
{
  this->Name = Name;
  File  = FileName;
  MinBB = 0;
  MaxBB = 0;
}

void SloProcedure::SetMinMaxBB (int MinBB, int MaxBB)
{
  this->MinBB = MinBB;
  this->MaxBB = MaxBB;
}

void SloProcedure::Print (void)
{
  std::cout << "Function: " << Name << " [" 
	    << MinBB << "," << MaxBB << "]" << std::endl;
}

void SloProcedure::setFunction (const SourceObjRef RefFunction)
{
  FuncObjRef = NULL;
  FuncObjRef = RefFunction;
}

int SloProcedure::GetMinBB (void) { return MinBB; }
int SloProcedure::GetMaxBB (void) { return MaxBB; }
const std::string&  SloProcedure::name (void) const { return Name; }
const std::string&  SloProcedure::file (void) const { return File; }
const SourceObjRef SloProcedure::function (void) const { return FuncObjRef; }


bool SloProcedure::classof(const SloProcedure*) { return true; }

static SloProcedure representativeProcedure_("representative" , "/dev/null");

bool SloProcedure::classof(const Procedure* proc)
{
    return proc->getRepresentativeProcedure() == &representativeProcedure_;
}

Procedure* SloProcedure::getRepresentativeProcedure() const
{
    return &representativeProcedure_;
}
