//===------------------------------------------------------------*- C++ -*-===//
//
//                    The PACE Application Aware Partitioner
//
// Copyright (C) 2009 - 2010, ET International, Inc. All rights reserved.
//
// The information and source code contained herein is the exclusive property
// of ET International, Inc. and may not be disclosed, examined or reproduced
// in whole or in part without explicit written authorization from the company.
//
// This software was produced under a U.S. Government contract with the Air
// Force Research Lab. The U.S. Government is licensed to use, reproduce,
// modify, and distribute this software for use within the U.S. Government.
// These rights are equivalent to:
// GOVERNMENT PURPOSE RIGHTS, CONTRACT: F33615-09-C-7915
//
//===----------------------------------------------------------------------===//

#ifndef AAP_SLOPROCEDURE_H
#define AAP_SLOPROCEDURE_H

#include "procedure.h"
#include "sourceobj.h"

namespace aap {

/// Represents a procedure in SLO database
class SloProcedure : public Procedure
{
 public:
  SloProcedure (const std::string&, const std::string&);

  const std::string& name     (void) const;
  const std::string& file     (void) const;
  const SourceObjRef function (void) const;

  void setFunction (const SourceObjRef);

  void SetMinMaxBB (int, int);
  int GetMinBB (void);
  int GetMaxBB (void);
  void Print (void);

  /// Support for llvm::dyn_cast et al.
  static bool classof(const Procedure*);
  static bool classof(const SloProcedure*);

protected:
  virtual Procedure* getRepresentativeProcedure() const;

 private:
  std::string Name;
  std::string File;
  int MinBB;
  int MaxBB;
  SourceObjRef FuncObjRef;

};

} // namespace aap

#endif // AAP_SLOPROCEDURE_H
