//===----------------------------------------------------------------------===//
//
//                    The PACE Application Aware Partitioner
//
// Copyright (C) 2009 - 2010, ET International, Inc. All rights reserved.
//
// The information and source code contained herein is the exclusive property
// of ET International, Inc. and may not be disclosed, examined or reproduced
// in whole or in part without explicit written authorization from the company.
//
// This software was produced under a U.S. Government contract with the Air
// Force Research Lab. The U.S. Government is licensed to use, reproduce,
// modify, and distribute this software for use within the U.S. Government.
// These rights are equivalent to:
// GOVERNMENT PURPOSE RIGHTS, CONTRACT: F33615-09-C-7915
//
//===----------------------------------------------------------------------===//

#include <iostream>
#include <string>
#include <sstream>

#include "hpcprocedure.h"
#include "utils/options.h"

using namespace std;
using namespace aap;

HpcProcedure::HpcProcedure (const string& name, const string& file)
    : name_ (name), file_ (file), ref_count_ (1),
      shouldOutput_ (true), retcnt_(0), wallclock_(0.0) { }

const std::string&
HpcProcedure::name (void) const
{
    return name_;
}

const std::string&
HpcProcedure::file (void) const
{
    return file_;
}

const SourceObjRef
HpcProcedure::function (void) const
{
    return func_;
}

void
HpcProcedure::incrementReferences (void)
{
    ref_count_++;
}

void
HpcProcedure::setFunction (const SourceObjRef func)
{
    func_ = NULL;
    func_ = func;
    if (!Options::injectPragmas(Options::kHpcProfilePragmas)) return;

    if (retcnt_) {
        std::ostringstream oss;
        oss << "HPC RETCNT " << retcnt_;
        PragmaInfo pragma(oss.str());
        func_->addPragma(pragma);
    }

    if (wallclock_) {
        std::ostringstream oss;
        oss << "HPC WALLCLOCK " << wallclock_;
        PragmaInfo pragma(oss.str());
        func_->addPragma(pragma);
    }
}

bool
HpcProcedure::shouldOutput (void) const
{
    return shouldOutput_;
}

void
HpcProcedure::setShouldOutput (bool output)
{
    shouldOutput_ = output;
}

bool HpcProcedure::classof(const HpcProcedure*)
{
    return true;
}

static HpcProcedure representativeProcedure_("representative","/dev/null");
bool HpcProcedure::classof(const Procedure* proc)
{
    return proc->getRepresentativeProcedure() == &representativeProcedure_;
}

Procedure* HpcProcedure::getRepresentativeProcedure() const
{
    return &representativeProcedure_;
}
