//===------------------------------------------------------------*- C++ -*-===//
//
//                    The PACE Application Aware Partitioner
//
// Copyright (C) 2009 - 2010, ET International, Inc. All rights reserved.
//
// The information and source code contained herein is the exclusive property
// of ET International, Inc. and may not be disclosed, examined or reproduced
// in whole or in part without explicit written authorization from the company.
//
// This software was produced under a U.S. Government contract with the Air
// Force Research Lab. The U.S. Government is licensed to use, reproduce,
// modify, and distribute this software for use within the U.S. Government.
// These rights are equivalent to:
// GOVERNMENT PURPOSE RIGHTS, CONTRACT: F33615-09-C-7915
//
//===----------------------------------------------------------------------===//

#ifndef AAP_PROFILING_PROCEDURE_H
#define AAP_PROFILING_PROCEDURE_H

#include <set>

#include "llvm/ADT/IntrusiveRefCntPtr.h"

#include "sourceobj.h"

namespace aap {

/// Represents a procedure in a profile.
class Procedure : public llvm::RefCountedBase<Procedure>
{
public:
    /// Returns the name of the procedure.
    virtual const std::string& name     (void) const = 0;
    /// Returns the file source file containing the procedure.
    virtual const std::string& file     (void) const = 0;
    /// Returns the SourceObject representing the procedure.
    virtual const SourceObjRef function (void) const = 0;

    /// Sets the SourceObject representing the procedure.
    virtual void setFunction     (const SourceObjRef) = 0;

    /// To support llvm::dyn_cast, subclasses should return a unique instance.
    /// The returned instance is not intended for any particular use.
    virtual Procedure* getRepresentativeProcedure() const = 0;

// protected:
//     virtual void Retain() = 0;
//     virtual void Release() = 0;
};

typedef llvm::IntrusiveRefCntPtr<Procedure> ProcedureRef;

} // namespace aap

#endif
