//===------------------------------------------------------------*- C++ -*-===//
//
//                    The PACE Application Aware Partitioner
//
// Copyright (C) 2009 - 2010, ET International, Inc. All rights reserved.
//
// The information and source code contained herein is the exclusive property
// of ET International, Inc. and may not be disclosed, examined or reproduced
// in whole or in part without explicit written authorization from the company.
//
// This software was produced under a U.S. Government contract with the Air
// Force Research Lab. The U.S. Government is licensed to use, reproduce,
// modify, and distribute this software for use within the U.S. Government.
// These rights are equivalent to:
// GOVERNMENT PURPOSE RIGHTS, CONTRACT: F33615-09-C-7915
//
//===----------------------------------------------------------------------===//

#ifndef AAP_RPUEXPORTER_H
#define AAP_RPUEXPORTER_H

#include <fstream>
#include <set>

#include "rpu.h"
#include "rpuoutput.h"

namespace aap {

/// Exports the SourceObj objects needed by an RPU into a file.

/// The method exportToFile should be invoked once after the RPU's dependencies
/// are fully determined.
class RpuExporter {
public:
    RpuExporter (RPU&);

    void  exportToFile (void);

private:
    void exportObj               (const SourceObjRef&);
    void exportVariable          (const SourceObjRef&);
    void exportVariableDirect    (const SourceObjRef&);
    void exportVariableIndirect  (const SourceObjRef&);
    void exportFunction          (const SourceObjRef&);
    void exportFunctionDirect    (const SourceObjRef&);
    void exportFunctionIndirect  (const SourceObjRef&);
    void exportPrototypeIndirect (const SourceObjRef&);

    void registerExportedObject (const SourceObjRef&);

    std::string mangledName (const SourceObjRef&);
    std::string mangledTargetName (const SourceObjRef&);
    std::string mangledVarName (const SourceObjRef&);

    void addCallReplacements (const SourceObjRef&,
                              std::map<std::string,std::string>&);
    void addRefReplacements (const SourceObjRef&,
                             std::map<std::string,std::string>&);

    RpuOutput     output_;
    RPU*          rpu_;
    std::set<std::string> knownTypes_; // types we have exported
};

} // namespace aap

#endif
