//===------------------------------------------------------------*- C++ -*-===//
//
//                    The PACE Application Aware Partitioner
//
// Copyright (C) 2009 - 2010, ET International, Inc. All rights reserved.
//
// The information and source code contained herein is the exclusive property
// of ET International, Inc. and may not be disclosed, examined or reproduced
// in whole or in part without explicit written authorization from the company.
//
// This software was produced under a U.S. Government contract with the Air
// Force Research Lab. The U.S. Government is licensed to use, reproduce,
// modify, and distribute this software for use within the U.S. Government.
// These rights are equivalent to:
// GOVERNMENT PURPOSE RIGHTS, CONTRACT: F33615-09-C-7915
//
//===----------------------------------------------------------------------===//

#ifndef AAP_RPUFACTORY_H
#define AAP_RPUFACTORY_H

#include <set>

namespace aap {

class RPU;

typedef std::set<RPU*> RPU_set;

/// Generates an RPU object from a graph representation.
class RpuFactory {

public:

    // Generate a set of RPUs based on the input graph. Each resulting RPU will
    // contain a reference to the HpcDatabase object.
    static RPU_set ConvertGraph (Agraph_t*);

    // Create an RPU containing any functions in the SourceFile that have not
    // thus far been extracted into an RPU
    static RPU_set* registerLeftovers (SourceFile&);

private:
    static RPU* ConvertDagSubgraph (Agraph_t*);
    static RPU* ConvertIndSubgraph (Agraph_t*);

    // Returns true if the named object has been exported from the named file
    static bool hasExported  (const std::string& objName,
                              const std::string& fileName);


};

} // namespace aap

#endif
