//===----------------------------------------------------------------------===//
//
//                    The PACE Application Aware Partitioner
//
// Copyright (C) 2009 - 2010, ET International, Inc. All rights reserved.
//
// The information and source code contained herein is the exclusive property
// of ET International, Inc. and may not be disclosed, examined or reproduced
// in whole or in part without explicit written authorization from the company.
//
// This software was produced under a U.S. Government contract with the Air
// Force Research Lab. The U.S. Government is licensed to use, reproduce,
// modify, and distribute this software for use within the U.S. Government.
// These rights are equivalent to:
// GOVERNMENT PURPOSE RIGHTS, CONTRACT: F33615-09-C-7915
//
//===----------------------------------------------------------------------===//

#include <cstdlib>
#include <string>

#include "graph/graph.h"
#include "rpu/rpu.h"
#include "rpu/rpugraphutil.h"
#include "utils/options.h"

using namespace aap;
using namespace std;

static const string kFunction = "function ";
static char kLabel[] = "label";

void
RpuGraphUtil::updateGraph (Agraph_t& graph, const RPU& rpu)
{
    // get the subgraph for that RPU
    string name = Options::rpuPrefix() + rpu.name();
    char* cName = strdup (name.c_str());
    Agraph_t* subg = agsubg (&graph, cName, FALSE);

    // RPUs generated from leftovers won't have an associated subgraph
    if (subg) {
        Agnode_t* node = agfstnode (subg);
        while (node) {
            char* label = agget (node, kLabel);
            if (label) {
                if (rpu.mangledNames_.count (kFunction + label)) {
                    string mangled = rpu.mangledNames_.at (kFunction + label);
                    char* cMangled = strdup (mangled.c_str());
                    agset (node, kLabel, cMangled);
                    free (cMangled);
                }
            }
            node = agnxtnode (subg, node);
        }
    }
    free (cName);
}
