//===------------------------------------------------------------*- C++ -*-===//
//
//                    The PACE Application Aware Partitioner
//
// Copyright (C) 2009 - 2010, ET International, Inc. All rights reserved.
//
// The information and source code contained herein is the exclusive property
// of ET International, Inc. and may not be disclosed, examined or reproduced
// in whole or in part without explicit written authorization from the company.
//
// This software was produced under a U.S. Government contract with the Air
// Force Research Lab. The U.S. Government is licensed to use, reproduce,
// modify, and distribute this software for use within the U.S. Government.
// These rights are equivalent to:
// GOVERNMENT PURPOSE RIGHTS, CONTRACT: F33615-09-C-7915
//
//===----------------------------------------------------------------------===//

#ifndef AAP_FUNCTIONPARSER_SOURCEEXTRACTOR_H
#define AAP_FUNCTIONPARSER_SOURCEEXTRACTOR_H

#include <map>
#include <string>

#include "rpu/rpuoutput.h"
#include "sourceobj.h"

namespace aap {

#define STRINGMAP std::map<std::string,std::string>

/// Extracts a SourceObj object to an output stream.
class SourceExtractor
{
public:
    SourceExtractor (const SourceObjRef object, RpuOutput& output);
    ~SourceExtractor (void);

    /// Adds a string replacement to be applied during extraction.
    void addReplacement (const std::string& from, const std::string& to);
    /// Calls addReplacement using for each map pair.
    void addReplacements (const std::map<std::string,std::string>&);

    /// Performs extraction.
    void extract (void);
    /// Performs extraction with "extern" pre-pended to the object.
    void extractExtern (void);
    /// Performs extraction with "extern" removed.
    void extractNonExtern (void);
    /// Performs extraction with "static" removed.
    void extractNonStatic (void);
    /// Performs extraction with "static" pre-pended.
    void extractStatic (void);

    /// Extract just the declaration portion of a source object.
    void extractDeclaration (void);
    /// Invokes extractDeclaration and pre-pends "extern".
    void extractExternDeclaration (void);

    /// Extracts a function with mangledName that redirect to the source object.
    void extractRedirection (const std::string& mangledName);

private:
    void extractComplete (std::string&, std::ifstream&);
    void extractFunctionDeclaration (std::ifstream&);

    const SourceObjRef obj_;
    RpuOutput&         output_;

    bool stripStorage_;         // should static / extern be removed
    bool declOnly_;             // do we only want the declaration
    std::string prefix_;        // text to prepend to the obj
    STRINGMAP* replace_;        // string replacements

    std::set<PragmaInfo>::const_iterator nextPragma_, pragmaEnd_;
};

#undef STRINGMAP

} // namespace aap

#endif
