//===------------------------------------------------------------*- C++ -*-===//
//
//                    The PACE Application Aware Partitioner
//
// Copyright (C) 2009 - 2010, ET International, Inc. All rights reserved.
//
// The information and source code contained herein is the exclusive property
// of ET International, Inc. and may not be disclosed, examined or reproduced
// in whole or in part without explicit written authorization from the company.
//
// This software was produced under a U.S. Government contract with the Air
// Force Research Lab. The U.S. Government is licensed to use, reproduce,
// modify, and distribute this software for use within the U.S. Government.
// These rights are equivalent to:
// GOVERNMENT PURPOSE RIGHTS, CONTRACT: F33615-09-C-7915
//
//===----------------------------------------------------------------------===//

#ifndef AAP_SOURCEFILEPARSER_H
#define AAP_SOURCEFILEPARSER_H

#include "sourcefile.h"

typedef struct Agraph_s Agraph_t;

namespace aap {

/// Parsers the files on which SourceFile objects are based using the
/// aap::AAPAction.
class SourceFileParser
{
public:
    /// Initializes the parser using the path to the mail executable in which
    /// it is running (i.e., arg[0]).
    static void Initialize(const char*);
    /// Parsers an individual source file.
    static void ParseFile(SourceFile& file);
    /// Parses all files that are known to the catalog.
    static void ParseKnownFiles (void);
    /// Parses all files referenced by objects in a profile graph.
    static void ParseFilesInGraph(Agraph_t* graph);
    /// Pre-processes a source file into the given output path.
    static void Preprocess(SourceFile &file, const std::string& outname = "");
    /// Returns true if diagnostic issues arose during any file parsing.
    static bool DiagnosticsOccured(void);
};

} // namespace aap

#endif
