//===------------------------------------------------------------*- C++ -*-===//
//
//                    The PACE Application Aware Partitioner
//
// Copyright (C) 2009 - 2010, ET International, Inc. All rights reserved.
//
// The information and source code contained herein is the exclusive property
// of ET International, Inc. and may not be disclosed, examined or reproduced
// in whole or in part without explicit written authorization from the company.
//
// This software was produced under a U.S. Government contract with the Air
// Force Research Lab. The U.S. Government is licensed to use, reproduce,
// modify, and distribute this software for use within the U.S. Government.
// These rights are equivalent to:
// GOVERNMENT PURPOSE RIGHTS, CONTRACT: F33615-09-C-7915
//
//===----------------------------------------------------------------------===//

#ifndef AAP_FUNCTIONPARSER_SOURCELOCATION_H
#define AAP_FUNCTIONPARSER_SOURCELOCATION_H

#include <string>

#include "clang/Basic/SourceLocation.h"

namespace clang {
  class SourceManager;
  class SourceRange;
}

namespace aap {

class SourceFile;

/// Represents the location of a SourceObj in a SourceFile.
class SourceLocation 
{
public:
    SourceLocation(clang::SourceRange&, clang::SourceManager&,
                   unsigned int EndOffset = 1,
                   unsigned int StartOffset = 0);

    // Generate a declaration-only version of this SourceLocation
    SourceLocation declaration (void) const;

    // The representation of a location is in transition. Originally it was
    // line:column number based, and going forward it's character offset (seek)
    int first_line   (void) const;
    int lastLine     (void) const;
    int originalLine (void) const;
    unsigned startPosition (void) const;
    unsigned endPosition   (void) const;

    bool declarationOnly   (void) const;
    bool needsSemiColon    (void) const;
    bool isUnknownLocation (void) const;

    const SourceFile& file (void) const;

    std::string originalFile  (void) const;

    void set_needs_semi_colon (bool);
    bool operator< (const SourceLocation&) const;
    bool operator== (const SourceLocation&) const;
    void setOriginalLocation (int, std::string&);

    static const SourceLocation* UnknownLocation;

    friend class SourceExtractor;

private:
    bool declaration_only_;
    bool needs_semi_colon_;
    bool isUnknownLocation_;
    int  original_line_;
    std::string original_file_; // The original (included) source file.
    std::string file_;          // The preprocessed source file.

    int StartLine;
    int EndLine;
    unsigned int StartPos;
    unsigned int EndPos;
  clang::SourceLocation start_;
  clang::SourceLocation end_;

    SourceLocation(void);
};

} // namespace aap

#endif
