/* #include <stdio.h> */
/* #include <unistd.h> */
/* #include <sys/time.h> */
/* #include <unistd.h> */
/* #include <stdlib.h> */
/* #include <sys/time.h> */
/* #include <math.h> */

void faux_printf(char*, ...);
double faux_sqrt(double);


#define my_sqrt_array(x,j) faux_sqrt(x[j])

#define N 2000
#define M 2000

float float_n = (float) N;
float eps = 0.005;
float stddev[M + 1];
float data[M + 1][N + 1];
float mean[M + 1];
float symmat[M + 1][M + 1];


#ifdef TIME
#define IF_TIME(foo) foo;
#else
#define IF_TIME(foo)
#endif

void init_array()
{
  int i, j;

  for (i=0; i<M; i++) {
    for (j=0; j<N; j++) {
      data[i][j] = ((float) i*j)/N;
    }
  }
}

void print_array()
{
  int i, j;
  for (i=0; i<M; i++) {
    for (j=0; j<M; j++) {
      faux_printf("%lf ", symmat[i][j]);
      if (i%80 == 20) faux_printf("\n");
    }
  }
  faux_printf("\n");
}

/* removed error handling and timing for AAP array padding tests */

int main(int argc, char** argv)
{
  double t_start, t_end;
  int i, j, j1, j2;
  int n = N;
  int m = M;
  // float *mean, *stddev;

  //if (fopen(".test", "r"))  {
  //  n = N/2;
  //  m = M/2;
  //}

  init_array();

  IF_TIME(t_start = rtclock());

  float float_n = (float) n;

  /* Allocate storage for mean and std. dev. vectors */
  // mean = vector(m);
  // stddev = vector(m);

  /* Determine mean of column vectors of input data matrix */
  for (j = 1; j <= m; j++)
  {
    mean[j] = 0.0;
    for (i = 1; i <= n; i++)
      mean[j] += data[i][j];
    mean[j] /= float_n;
  }

  /* Determine standard deviations of column vectors of data matrix. */
  for (j = 1; j <= m; j++)
  {
    stddev[j] = 0.0;
    for (i = 1; i <= n; i++)
      stddev[j] += (data[i][j] - mean[j]) * (data[i][j] - mean[j]);
    stddev[j] /= float_n;
    stddev[j] = faux_sqrt(stddev[j]);
    /* The following in an inelegant but usual way to handle
       near-zero std. dev. values, which below would cause a zero-
       divide. */
    stddev[j] = stddev[j] <= eps ? 1.0 : stddev[j];
  }

#pragma scop
  /* Center and reduce the column vectors. */
  for (i = 1; i <= n; i++)
    for (j = 1; j <= m; j++)
    {
      data[i][j] -= mean[j];
      data[i][j] /= faux_sqrt(float_n) * stddev[j];
    }

  /* Calculate the m * m correlation matrix. */
  for (j1 = 1; j1 <= m-1; j1++)
  {
    symmat[j1][j1] = 1.0;
    for (j2 = j1+1; j2 <= m; j2++)
    {
      symmat[j1][j2] = 0.0;
      for (i = 1; i <= n; i++)
        symmat[j1][j2] += ( data[i][j1] * data[i][j2]);
      symmat[j2][j1] = symmat[j1][j2];
    }
  }
#pragma endscop
  symmat[m][m] = 1.0;

  IF_TIME(t_end = rtclock());
  IF_TIME(faux_printf("%0.6lfs\n", t_end - t_start));

  //if (fopen(".test", "r")) {
    print_array();
  //}


  return 0;
}
