/* #include <stdio.h> */
/* #include <unistd.h> */
/* #include <sys/time.h> */
/* #include <unistd.h> */
/* #include <sys/time.h> */
/* #include <math.h> */

void faux_printf(char*, ...);

#define N 1000
#define M 1000

float float_n = (float) N;
float eps = 0.005;
float stddev[M + 1];
float data[M + 1][N + 1];
float mean[M + 1];
float symmat[M + 1][M + 1];

#ifdef TIME
#define IF_TIME(foo)
#else
#define IF_TIME(foo)
#endif

void init_array()
{
    int i, j;
    int n = N;
    int m = M;

    for (i=0; i<=n; i++) {
      for (j=0; j<=m; j++) {
        data[i][j] = ((float) i*j)/N;
      }
    }
}

void print_array()
{
  int i, j;
  int n = N;
  int m = M;
  for (i=1; i<=m; i++) {
    for (j=1; j<=m; j++) {
      faux_printf("%0.2lf ", symmat[i][j]);
      if (i%80 == 20) faux_printf("\n");
    }
  }
  faux_printf("\n");
}

#ifdef TIME
#define IF_TIME(foo) foo;
#else
#define IF_TIME(foo)
#endif

int main(int argc, char** argv)
{
  double t_start, t_end;
  int i, j, j1, j2;
  int n = N;
  int m = M;

  init_array();

  IF_TIME(t_start = rtclock());

#pragma scop
  /* Determine mean of column vectors of input data matrix */
  for (j = 1; j <= m; j++) {
    mean[j] = 0.0;
    for (i = 1; i <= n; i++)
      mean[j] += data[i][j];
    mean[j] /= float_n;
  }

  /* Center the column vectors. */
  for (i = 1; i <= n; i++)
    for (j = 1; j <= m; j++)
      data[i][j] -= mean[j];

  /* Calculate the m * m covariance matrix. */
  for (j1 = 1; j1 <= m; j1++) {
    for (j2 = j1; j2 <= m; j2++) {
      symmat[j1][j2] = 0.0;
      for (i = 1; i <= n; i++) {
        symmat[j1][j2] += data[i][j1] * data[i][j2];
      }
      symmat[j2][j1] = symmat[j1][j2];
    }
  }
#pragma endscop

  IF_TIME(t_end = rtclock());
  IF_TIME(fprintf(stderr, "%0.6lfs\n", t_end - t_start));

  //if (fopen(".test", "r"))  {
    print_array();
  //}

  return 0;
}
