
#include "decls.h"

#include "util.h"

#define ceild(n,d)  ceil(((double)(n))/((double)(d)))
#define floord(n,d) floor(((double)(n))/((double)(d)))
#define max(x,y)    ((x) > (y)? (x) : (y))
#define min(x,y)    ((x) < (y)? (x) : (y))

// A number of the uses of these macros involve non-trivial arithmetic that
// causes the array padding analysis to mark the arrays as unsafe for padding.
// It's not immediately clear whether this particular case should be safe, but
// it's "correct" to disallow such math within the subscripts.

#define S1(t,j)	{ey[0][j]=t;}
#define S2(t,i,j)	{ey[i][j]=ey[i][j]-((double)(1))/2*(hz[i][j]-hz[i-1][j]);}
#define S3(t,i,j)	{ex[i][j]=ex[i][j]-((double)(1))/2*(hz[i][j]-hz[i][j-1]);}
#define S4(t,i,j)	{hz[i][j]=hz[i][j]-((double)(7))/10*(ey[1+i][j]+ex[i][1+j]-ex[i][j]-ey[i][j]);}

double t_start, t_end;

int main()
{
	int c1, c2, c3, c4, c5, c6;
	int i, j, k, l, m, n, t;

	register int lb, ub;

/* Generated from fdtd-2d.sched.cloog by CLooG v0.14.1 64 bits in 1.00s. */
for (c1=-1;c1<=floord(2*tmax+ny-2,32);c1++) {
    lb = max(max(ceild(32*c1-tmax+1,32),ceild(32*c1-31,64)),0);
    ub = min(min(floord(tmax+ny-1,32),floord(32*c1+ny+31,64)),floord(32*c1+31,32));
#pragma omp parallel for shared(c1,lb,ub) private(c2,c3,c4,c5,c6)
  for (c2=lb;c2<=ub;c2++) {
    for (c3=max(max(max(max(ceild(32*c2-ny-30,32),0),ceild(64*c1-96*c2-61,32)),ceild(32*c1-32*c2-31,32)),ceild(32*c1-1024*c2-1891,992));c3<=min(min(floord(32*c2+nx+30,32),floord(32*c1-32*c2+nx+31,32)),floord(tmax+nx-1,32));c3++) {
      if ((c1 == c2+c3) && (c2 <= 0) && (c2 >= 0) && (c3 <= 0) && (c3 >= 0)) {
          S1(0,0) ;
        for (c6=1;c6<=32*c3+31;c6++) {
            S2(0,c6,0) ;
        }
        for (c5=1;c5<=32*c2+31;c5++) {
            S1(0,c5) ;
            S3(0,0,c5) ;
          for (c6=1;c6<=32*c3+31;c6++) {
              S2(0,c6,c5) ;
              S3(0,c6,c5) ;
          }
        }
      }
      if ((c1 == c2+c3) && (c2 <= floord(ny-1,32)) && (c2 >= 1) && (c3 <= 0) && (c3 >= 0)) {
        for (c5=32*c2;c5<=min(32*c2+31,ny-1);c5++) {
            S1(0,c5) ;
            S3(0,0,c5) ;
          for (c6=1;c6<=32*c3+31;c6++) {
              S2(0,c6,c5) ;
              S3(0,c6,c5) ;
          }
        }
      }
      if ((-c1 == -c2-c3) && (c1 >= max(ceild(128*c2-1,64),ceild(64*c2+1,64))) && (c1 <= floord(32*c2+15,16))) {
        for (c5=max(32*c2,32*c1-32*c2);c5<=floord(64*c1-64*c2+1,2);c5++) {
            S1(32*c1-32*c2,-32*c1+32*c2+c5) ;
          for (c6=32*c1-32*c2+1;c6<=32*c1-32*c2+31;c6++) {
              S2(32*c1-32*c2,-32*c1+32*c2+c6,-32*c1+32*c2+c5) ;
          }
        }
        for (c5=32*c1-32*c2+1;c5<=32*c2+31;c5++) {
            S1(32*c1-32*c2,-32*c1+32*c2+c5) ;
            S3(32*c1-32*c2,0,-32*c1+32*c2+c5) ;
          for (c6=32*c1-32*c2+1;c6<=32*c1-32*c2+31;c6++) {
              S2(32*c1-32*c2,-32*c1+32*c2+c6,-32*c1+32*c2+c5) ;
              S3(32*c1-32*c2,-32*c1+32*c2+c6,-32*c1+32*c2+c5) ;
          }
        }
      }
      if ((-c1 == -c2-c3) && (c1 >= max(ceild(64*c2+1,64),ceild(64*c2-ny+1,32))) && (c1 <= floord(64*c2-1,32))) {
        for (c5=32*c2;c5<=min(32*c2+31,32*c1-32*c2+ny-1);c5++) {
            S1(32*c1-32*c2,-32*c1+32*c2+c5) ;
            S3(32*c1-32*c2,0,-32*c1+32*c2+c5) ;
          for (c6=32*c1-32*c2+1;c6<=32*c1-32*c2+31;c6++) {
              S2(32*c1-32*c2,-32*c1+32*c2+c6,-32*c1+32*c2+c5) ;
              S3(32*c1-32*c2,-32*c1+32*c2+c6,-32*c1+32*c2+c5) ;
          }
        }
      }
      if ((c1 <= c2) && (c2 <= 0) && (c2 >= 0) && (c3 >= 1) && (c3 <= floord(nx-1,32))) {
        for (c6=max(1,32*c3);c6<=min(32*c3+31,nx-1);c6++) {
            S2(0,c6,0) ;
        }
        for (c5=1;c5<=32*c2+31;c5++) {
          for (c6=max(1,32*c3);c6<=min(32*c3+31,nx-1);c6++) {
              S2(0,c6,c5) ;
              S3(0,c6,c5) ;
          }
        }
      }
      if ((c1 <= c2) && (c2 <= floord(ny-1,32)) && (c2 >= 1) && (c3 >= 1) && (c3 <= floord(nx-1,32))) {
        for (c5=32*c2;c5<=min(32*c2+31,ny-1);c5++) {
          for (c6=max(1,32*c3);c6<=min(32*c3+31,nx-1);c6++) {
              S2(0,c6,c5) ;
              S3(0,c6,c5) ;
          }
        }
      }
      if ((c1 >= max(max(ceild(128*c2-1,64),ceild(64*c2+1,64)),ceild(32*c2+32*c3-nx+1,32))) && (c1 <= min(floord(32*c2+32*c3-1,32),floord(32*c2+15,16)))) {
        for (c5=max(32*c2,32*c1-32*c2);c5<=floord(64*c1-64*c2+1,2);c5++) {
          for (c6=32*c3;c6<=min(32*c3+31,32*c1-32*c2+nx-1);c6++) {
              S2(32*c1-32*c2,-32*c1+32*c2+c6,-32*c1+32*c2+c5) ;
          }
        }
        for (c5=32*c1-32*c2+1;c5<=32*c2+31;c5++) {
          for (c6=32*c3;c6<=min(32*c3+31,32*c1-32*c2+nx-1);c6++) {
              S2(32*c1-32*c2,-32*c1+32*c2+c6,-32*c1+32*c2+c5) ;
              S3(32*c1-32*c2,-32*c1+32*c2+c6,-32*c1+32*c2+c5) ;
          }
        }
      }
      if ((c1 >= max(max(ceild(64*c2-ny+1,32),ceild(64*c2+1,64)),ceild(32*c2+32*c3-nx+1,32))) && (c1 <= min(floord(64*c2-1,32),floord(32*c2+32*c3-1,32)))) {
        for (c5=32*c2;c5<=min(32*c1-32*c2+ny-1,32*c2+31);c5++) {
          for (c6=32*c3;c6<=min(32*c3+31,32*c1-32*c2+nx-1);c6++) {
              S2(32*c1-32*c2,-32*c1+32*c2+c6,-32*c1+32*c2+c5) ;
              S3(32*c1-32*c2,-32*c1+32*c2+c6,-32*c1+32*c2+c5) ;
          }
        }
      }
      if ((c1 <= floord(64*c2-ny,32)) && (c2 >= max(ceild(32*c3-nx+ny,32),ceild(ny,32))) && (c2 <= floord(2*tmax+2*ny-3,64))) {
        for (c6=max(32*c2-ny+1,32*c3);c6<=min(32*c2+nx-ny,32*c3+31);c6++) {
            S4(32*c2-ny,-32*c2+c6+ny-1,ny-1) ;
        }
      }
      if ((c1 >= ceild(64*c2+64*c3-2*nx-61,64)) && (c1 <= floord(32*c2+32*c3-nx,32)) && (c2 <= floord(64*c3-2*nx+2*ny-1,64)) && (c3 <= floord(2*tmax+2*nx-3,64)) && (c3 >= ceild(nx,32))) {
        for (c5=max(32*c2,32*c3-nx+1);c5<=min(32*c2+31,32*c3-nx+ny);c5++) {
            S4(32*c3-nx,nx-1,-32*c3+c5+nx-1) ;
        }
      }
      if (c1 == c2+c3) {
        for (c4=max(max(64*c3+1,64*c2-2*ny+2),1);c4<=min(min(2*tmax-2,64*c2-2*ny+63),64*c3+60);c4++) {
          for (c5=32*c2;c5<=floord(c4+2*ny-2,2);c5++) {
            if (c4%2 == 0) {
              if (c4%2 == 0) {
                if (-c4%2 == 0) {
                    S1(c4/2,(-c4+2*c5)/2) ;
                }
              }
              if (c4%2 == 0) {
                if (-c4%2 == 0) {
                    S3(c4/2,0,(-c4+2*c5)/2) ;
                }
              }
            }
            if ((c4+1)%2 == 0) {
              if ((c4-1)%2 == 0) {
                if ((-c4-1)%2 == 0) {
                    S4((c4-1)/2,0,(-c4+2*c5-1)/2) ;
                }
              }
            }
            for (c6=ceild(c4+2,2);c6<=32*c3+31;c6++) {
              if (c4%2 == 0) {
                if (-c4%2 == 0) {
                  if (-c4%2 == 0) {
                      S2(c4/2,(-c4+2*c6)/2,(-c4+2*c5)/2) ;
                  }
                }
              }
              if (c4%2 == 0) {
                if (-c4%2 == 0) {
                  if (-c4%2 == 0) {
                      S3(c4/2,(-c4+2*c6)/2,(-c4+2*c5)/2) ;
                  }
                }
              }
              if ((c4-1)%2 == 0) {
                if ((-c4-1)%2 == 0) {
                  if ((-c4-1)%2 == 0) {
                      S4((c4-1)/2,(-c4+2*c6-1)/2,(-c4+2*c5-1)/2) ;
                  }
                }
              }
            }
          }
          if ((c4-1)%2 == 0) {
            for (c6=ceild(c4+1,2);c6<=32*c3+31;c6++) {
              if ((c4-1)%2 == 0) {
                if ((-c4-1)%2 == 0) {
                    S4((c4-1)/2,(-c4+2*c6-1)/2,ny-1) ;
                }
              }
            }
          }
        }
      }
      if (c1 == c2+c3) {
        for (c4=max(max(1,64*c3+1),64*c2-2*ny+64);c4<=min(min(64*c3+60,2*tmax-2),64*c2-2);c4++) {
          for (c5=32*c2;c5<=32*c2+31;c5++) {
            if (c4%2 == 0) {
              if (c4%2 == 0) {
                if (-c4%2 == 0) {
                    S1(c4/2,(-c4+2*c5)/2) ;
                }
              }
              if (c4%2 == 0) {
                if (-c4%2 == 0) {
                    S3(c4/2,0,(-c4+2*c5)/2) ;
                }
              }
            }
            if ((c4+1)%2 == 0) {
              if ((c4-1)%2 == 0) {
                if ((-c4-1)%2 == 0) {
                    S4((c4-1)/2,0,(-c4+2*c5-1)/2) ;
                }
              }
            }
            for (c6=ceild(c4+2,2);c6<=32*c3+31;c6++) {
              if (c4%2 == 0) {
                if (-c4%2 == 0) {
                  if (-c4%2 == 0) {
                      S2(c4/2,(-c4+2*c6)/2,(-c4+2*c5)/2) ;
                  }
                }
              }
              if (c4%2 == 0) {
                if (-c4%2 == 0) {
                  if (-c4%2 == 0) {
                      S3(c4/2,(-c4+2*c6)/2,(-c4+2*c5)/2) ;
                  }
                }
              }
              if ((c4-1)%2 == 0) {
                if ((-c4-1)%2 == 0) {
                  if ((-c4-1)%2 == 0) {
                      S4((c4-1)/2,(-c4+2*c6-1)/2,(-c4+2*c5-1)/2) ;
                  }
                }
              }
            }
          }
        }
      }
      if ((-c1 == -c2-c3) && (c1 >= max(ceild(32*c3+1,32),ceild(64*c3+1,32))) && (c1 <= min(floord(128*c3+61,64),floord(64*c3+2*tmax-1,64)))) {
          S4(32*c1-32*c3-1,0,0) ;
        for (c6=ceild(64*c1-64*c3+1,2);c6<=32*c3+31;c6++) {
            S4(32*c1-32*c3-1,-32*c1+32*c3+c6,0) ;
        }
        for (c5=ceild(64*c1-64*c3+1,2);c5<=32*c1-32*c3+31;c5++) {
            S4(32*c1-32*c3-1,0,-32*c1+32*c3+c5) ;
          for (c6=ceild(64*c1-64*c3+1,2);c6<=32*c3+31;c6++) {
              S4(32*c1-32*c3-1,-32*c1+32*c3+c6,-32*c1+32*c3+c5) ;
          }
        }
      }
      if (c1 == c2+c3) {
        for (c4=max(max(64*c2,1),64*c3+1);c4<=min(min(64*c3+60,2*tmax-2),64*c2+60);c4++) {
          if (c4%2 == 0) {
            if (c4%2 == 0) {
              if (c4%2 == 0) {
                  S1(c4/2,0) ;
              }
            }
            for (c6=ceild(c4+2,2);c6<=32*c3+31;c6++) {
              if (c4%2 == 0) {
                if (-c4%2 == 0) {
                    S2(c4/2,(-c4+2*c6)/2,0) ;
                }
              }
            }
          }
          if ((c4+1)%2 == 0) {
            if ((c4+1)%2 == 0) {
              if ((c4-1)%2 == 0) {
                  S4((c4-1)/2,0,0) ;
              }
            }
            for (c6=ceild(c4+2,2);c6<=32*c3+31;c6++) {
              if ((c4-1)%2 == 0) {
                if ((-c4-1)%2 == 0) {
                    S4((c4-1)/2,(-c4+2*c6-1)/2,0) ;
                }
              }
            }
          }
          for (c5=ceild(c4+2,2);c5<=32*c2+31;c5++) {
            if (c4%2 == 0) {
              if (c4%2 == 0) {
                if (-c4%2 == 0) {
                    S1(c4/2,(-c4+2*c5)/2) ;
                }
              }
              if (c4%2 == 0) {
                if (-c4%2 == 0) {
                    S3(c4/2,0,(-c4+2*c5)/2) ;
                }
              }
            }
            if ((c4+1)%2 == 0) {
              if ((c4-1)%2 == 0) {
                if ((-c4-1)%2 == 0) {
                    S4((c4-1)/2,0,(-c4+2*c5-1)/2) ;
                }
              }
            }
            for (c6=ceild(c4+2,2);c6<=32*c3+31;c6++) {
              if (c4%2 == 0) {
                if (-c4%2 == 0) {
                  if (-c4%2 == 0) {
                      S2(c4/2,(-c4+2*c6)/2,(-c4+2*c5)/2) ;
                  }
                }
              }
              if (c4%2 == 0) {
                if (-c4%2 == 0) {
                  if (-c4%2 == 0) {
                      S3(c4/2,(-c4+2*c6)/2,(-c4+2*c5)/2) ;
                  }
                }
              }
              if ((c4-1)%2 == 0) {
                if ((-c4-1)%2 == 0) {
                  if ((-c4-1)%2 == 0) {
                      S4((c4-1)/2,(-c4+2*c6-1)/2,(-c4+2*c5-1)/2) ;
                  }
                }
              }
            }
          }
        }
      }
      for (c4=max(max(max(64*c2-2*ny+2,64*c3-2*nx+2),1),64*c1-64*c2+1);c4<=min(min(min(64*c3-2*nx+63,64*c1-64*c2+62),64*c2-2*ny+63),2*tmax-2);c4++) {
        for (c5=32*c2;c5<=floord(c4+2*ny-2,2);c5++) {
          for (c6=32*c3;c6<=floord(c4+2*nx-2,2);c6++) {
            if (c4%2 == 0) {
              if (-c4%2 == 0) {
                if (-c4%2 == 0) {
                    S2(c4/2,(-c4+2*c6)/2,(-c4+2*c5)/2) ;
                }
              }
            }
            if (c4%2 == 0) {
              if (-c4%2 == 0) {
                if (-c4%2 == 0) {
                    S3(c4/2,(-c4+2*c6)/2,(-c4+2*c5)/2) ;
                }
              }
            }
            if ((c4-1)%2 == 0) {
              if ((-c4-1)%2 == 0) {
                if ((-c4-1)%2 == 0) {
                    S4((c4-1)/2,(-c4+2*c6-1)/2,(-c4+2*c5-1)/2) ;
                }
              }
            }
          }
          if ((c4-1)%2 == 0) {
            if ((c4-1)%2 == 0) {
              if ((-c4-1)%2 == 0) {
                  S4((c4-1)/2,nx-1,(-c4+2*c5-1)/2) ;
              }
            }
          }
        }
        if ((c4-1)%2 == 0) {
          for (c6=32*c3;c6<=floord(c4+2*nx-1,2);c6++) {
            if ((c4-1)%2 == 0) {
              if ((-c4-1)%2 == 0) {
                  S4((c4-1)/2,(-c4+2*c6-1)/2,ny-1) ;
              }
            }
          }
        }
      }
      for (c4=max(max(max(64*c3-2*nx+2,1),64*c1-64*c2+1),64*c2-2*ny+64);c4<=min(min(min(64*c1-64*c2+62,2*tmax-2),64*c2-2),64*c3-2*nx+63);c4++) {
        for (c5=32*c2;c5<=32*c2+31;c5++) {
          for (c6=32*c3;c6<=floord(c4+2*nx-2,2);c6++) {
            if (c4%2 == 0) {
              if (-c4%2 == 0) {
                if (-c4%2 == 0) {
                    S2(c4/2,(-c4+2*c6)/2,(-c4+2*c5)/2) ;
                }
              }
            }
            if (c4%2 == 0) {
              if (-c4%2 == 0) {
                if (-c4%2 == 0) {
                    S3(c4/2,(-c4+2*c6)/2,(-c4+2*c5)/2) ;
                }
              }
            }
            if ((c4-1)%2 == 0) {
              if ((-c4-1)%2 == 0) {
                if ((-c4-1)%2 == 0) {
                    S4((c4-1)/2,(-c4+2*c6-1)/2,(-c4+2*c5-1)/2) ;
                }
              }
            }
          }
          if ((c4-1)%2 == 0) {
            if ((c4-1)%2 == 0) {
              if ((-c4-1)%2 == 0) {
                  S4((c4-1)/2,nx-1,(-c4+2*c5-1)/2) ;
              }
            }
          }
        }
      }
      for (c4=max(max(max(64*c3-2*nx+64,64*c2-2*ny+2),1),64*c1-64*c2+1);c4<=min(min(min(64*c3-2,64*c1-64*c2+62),64*c2-2*ny+63),2*tmax-2);c4++) {
        for (c5=32*c2;c5<=floord(c4+2*ny-2,2);c5++) {
          for (c6=32*c3;c6<=32*c3+31;c6++) {
            if (c4%2 == 0) {
              if (-c4%2 == 0) {
                if (-c4%2 == 0) {
                    S2(c4/2,(-c4+2*c6)/2,(-c4+2*c5)/2) ;
                }
              }
            }
            if (c4%2 == 0) {
              if (-c4%2 == 0) {
                if (-c4%2 == 0) {
                    S3(c4/2,(-c4+2*c6)/2,(-c4+2*c5)/2) ;
                }
              }
            }
            if ((c4-1)%2 == 0) {
              if ((-c4-1)%2 == 0) {
                if ((-c4-1)%2 == 0) {
                    S4((c4-1)/2,(-c4+2*c6-1)/2,(-c4+2*c5-1)/2) ;
                }
              }
            }
          }
        }
        if ((c4-1)%2 == 0) {
          for (c6=32*c3;c6<=32*c3+31;c6++) {
            if ((c4-1)%2 == 0) {
              if ((-c4-1)%2 == 0) {
                  S4((c4-1)/2,(-c4+2*c6-1)/2,ny-1) ;
              }
            }
          }
        }
      }
      if ((c1 >= ceild(128*c2-63,64)) && (c1 <= floord(64*c2-1,32)) && (c2 <= min(floord(2*tmax-1,64),floord(32*c3-nx+32,32))) && (c2 >= max(ceild(64*c3-2*nx+3,64),1))) {
        for (c6=32*c3;c6<=floord(64*c2+2*nx-3,2);c6++) {
            S4(32*c2-1,-32*c2+c6,0) ;
        }
          S4(32*c2-1,nx-1,0) ;
        for (c5=ceild(64*c2+1,2);c5<=32*c2+31;c5++) {
          for (c6=32*c3;c6<=floord(64*c2+2*nx-3,2);c6++) {
              S4(32*c2-1,-32*c2+c6,-32*c2+c5) ;
          }
            S4(32*c2-1,nx-1,-32*c2+c5) ;
        }
      }
      if ((c1 >= ceild(64*c2+64*c3-63,64)) && (c1 <= floord(32*c2+32*c3-1,32)) && (c2 >= ceild(32*c3+ny-32,32)) && (c2 <= floord(64*c3+2*ny-3,64)) && (c3 <= floord(2*tmax-1,64)) && (c3 >= 1)) {
        for (c5=32*c2;c5<=floord(64*c3+2*ny-3,2);c5++) {
            S4(32*c3-1,0,-32*c3+c5) ;
          for (c6=ceild(64*c3+1,2);c6<=32*c3+31;c6++) {
              S4(32*c3-1,-32*c3+c6,-32*c3+c5) ;
          }
        }
        for (c6=32*c3;c6<=32*c3+31;c6++) {
            S4(32*c3-1,-32*c3+c6,ny-1) ;
        }
      }
      for (c4=max(max(max(64*c1-64*c2+1,1),64*c3-2*nx+64),64*c2-2*ny+64);c4<=min(min(min(64*c3-2,64*c1-64*c2+62),2*tmax-2),64*c2-2);c4++) {
        for (c5=32*c2;c5<=32*c2+31;c5++) {
          for (c6=32*c3;c6<=32*c3+31;c6++) {
            if (c4%2 == 0) {
              if (-c4%2 == 0) {
                if (-c4%2 == 0) {
                    S2(c4/2,(-c4+2*c6)/2,(-c4+2*c5)/2) ;
                }
              }
            }
            if (c4%2 == 0) {
              if (-c4%2 == 0) {
                if (-c4%2 == 0) {
                    S3(c4/2,(-c4+2*c6)/2,(-c4+2*c5)/2) ;
                }
              }
            }
            if ((c4-1)%2 == 0) {
              if ((-c4-1)%2 == 0) {
                if ((-c4-1)%2 == 0) {
                    S4((c4-1)/2,(-c4+2*c6-1)/2,(-c4+2*c5-1)/2) ;
                }
              }
            }
          }
        }
      }
      for (c4=max(max(max(64*c2,64*c3-2*nx+2),1),64*c1-64*c2+1);c4<=min(min(min(64*c1-64*c2+62,2*tmax-2),64*c2+60),64*c3-2*nx+63);c4++) {
        if (c4%2 == 0) {
          for (c6=32*c3;c6<=floord(c4+2*nx-2,2);c6++) {
            if (c4%2 == 0) {
              if (-c4%2 == 0) {
                  S2(c4/2,(-c4+2*c6)/2,0) ;
              }
            }
          }
        }
        if ((c4+1)%2 == 0) {
          for (c6=32*c3;c6<=floord(c4+2*nx-2,2);c6++) {
            if ((c4-1)%2 == 0) {
              if ((-c4-1)%2 == 0) {
                  S4((c4-1)/2,(-c4+2*c6-1)/2,0) ;
              }
            }
          }
          if ((c4-1)%2 == 0) {
            if ((c4-1)%2 == 0) {
                S4((c4-1)/2,nx-1,0) ;
            }
          }
        }
        for (c5=ceild(c4+2,2);c5<=32*c2+31;c5++) {
          for (c6=32*c3;c6<=floord(c4+2*nx-2,2);c6++) {
            if (c4%2 == 0) {
              if (-c4%2 == 0) {
                if (-c4%2 == 0) {
                    S2(c4/2,(-c4+2*c6)/2,(-c4+2*c5)/2) ;
                }
              }
            }
            if (c4%2 == 0) {
              if (-c4%2 == 0) {
                if (-c4%2 == 0) {
                    S3(c4/2,(-c4+2*c6)/2,(-c4+2*c5)/2) ;
                }
              }
            }
            if ((c4-1)%2 == 0) {
              if ((-c4-1)%2 == 0) {
                if ((-c4-1)%2 == 0) {
                    S4((c4-1)/2,(-c4+2*c6-1)/2,(-c4+2*c5-1)/2) ;
                }
              }
            }
          }
          if ((c4-1)%2 == 0) {
            if ((c4-1)%2 == 0) {
              if ((-c4-1)%2 == 0) {
                  S4((c4-1)/2,nx-1,(-c4+2*c5-1)/2) ;
              }
            }
          }
        }
      }
      if ((c1 <= floord(64*c2-1,32)) && (c1 >= ceild(128*c2-63,64)) && (-c2 == -c3) && (c2 <= floord(2*tmax-1,64))) {
          S4(32*c2-1,0,0) ;
        for (c6=ceild(64*c2+1,2);c6<=32*c2+31;c6++) {
            S4(32*c2-1,-32*c2+c6,0) ;
        }
        for (c5=ceild(64*c2+1,2);c5<=32*c2+31;c5++) {
            S4(32*c2-1,0,-32*c2+c5) ;
          for (c6=ceild(64*c2+1,2);c6<=32*c2+31;c6++) {
              S4(32*c2-1,-32*c2+c6,-32*c2+c5) ;
          }
        }
      }
      if ((c1 <= floord(64*c2-1,32)) && (c1 >= ceild(128*c2-63,64)) && (c2 >= max(ceild(32*c3-nx+33,32),1)) && (c2 <= min(floord(32*c3-1,32),floord(2*tmax-1,64)))) {
        for (c6=32*c3;c6<=32*c3+31;c6++) {
            S4(32*c2-1,-32*c2+c6,0) ;
        }
        for (c5=ceild(64*c2+1,2);c5<=32*c2+31;c5++) {
          for (c6=32*c3;c6<=32*c3+31;c6++) {
              S4(32*c2-1,-32*c2+c6,-32*c2+c5) ;
          }
        }
      }
      if ((c1 <= floord(32*c2+32*c3-1,32)) && (c1 >= ceild(64*c2+64*c3-63,64)) && (c2 >= ceild(64*c3+1,64)) && (c2 <= floord(64*c3+2*ny-65,64)) && (c3 <= floord(2*tmax-1,64)) && (c3 >= 1)) {
        for (c5=32*c2;c5<=32*c2+31;c5++) {
            S4(32*c3-1,0,-32*c3+c5) ;
          for (c6=ceild(64*c3+1,2);c6<=32*c3+31;c6++) {
              S4(32*c3-1,-32*c3+c6,-32*c3+c5) ;
          }
        }
      }
      if ((c1 <= floord(64*c2+64*c3-2*nx+63,64)) && (c1 >= ceild(32*c2+32*c3-nx+1,32)) && (c2 <= floord(32*c3-nx+32,32)) && (c2 >= ceild(32*c3-nx+2,32)) && (c3 <= floord(tmax+nx-33,32)) && (c3 >= ceild(2*nx-63,64))) {
        for (c6=32*c3;c6<=32*c3+31;c6++) {
            S2(32*c3-nx+32,-32*c3+c6+nx-32,0) ;
        }
        for (c5=32*c3-nx+33;c5<=32*c2+31;c5++) {
          for (c6=32*c3;c6<=32*c3+31;c6++) {
              S2(32*c3-nx+32,-32*c3+c6+nx-32,-32*c3+c5+nx-32) ;
              S3(32*c3-nx+32,-32*c3+c6+nx-32,-32*c3+c5+nx-32) ;
          }
        }
      }
      for (c4=max(max(max(64*c2,64*c3-2*nx+65),64*c1-64*c2+1),1);c4<=min(min(min(64*c3-3,2*tmax-2),64*c1-64*c2+62),64*c2+60);c4++) {
        if (c4%2 == 0) {
          for (c6=32*c3;c6<=32*c3+31;c6++) {
            if (c4%2 == 0) {
              if (-c4%2 == 0) {
                  S2(c4/2,(-c4+2*c6)/2,0) ;
              }
            }
          }
        }
        if ((c4+1)%2 == 0) {
          for (c6=32*c3;c6<=32*c3+31;c6++) {
            if ((c4-1)%2 == 0) {
              if ((-c4-1)%2 == 0) {
                  S4((c4-1)/2,(-c4+2*c6-1)/2,0) ;
              }
            }
          }
        }
        for (c5=ceild(c4+2,2);c5<=32*c2+31;c5++) {
          for (c6=32*c3;c6<=32*c3+31;c6++) {
            if (c4%2 == 0) {
              if (-c4%2 == 0) {
                if (-c4%2 == 0) {
                    S2(c4/2,(-c4+2*c6)/2,(-c4+2*c5)/2) ;
                }
              }
            }
            if (c4%2 == 0) {
              if (-c4%2 == 0) {
                if (-c4%2 == 0) {
                    S3(c4/2,(-c4+2*c6)/2,(-c4+2*c5)/2) ;
                }
              }
            }
            if ((c4-1)%2 == 0) {
              if ((-c4-1)%2 == 0) {
                if ((-c4-1)%2 == 0) {
                    S4((c4-1)/2,(-c4+2*c6-1)/2,(-c4+2*c5-1)/2) ;
                }
              }
            }
          }
        }
      }
      if ((c1 <= floord(64*c2+64*c3-3,64)) && (c1 >= c2+c3-1) && (c2 <= floord(32*c3-1,32)) && (c2 >= ceild(32*c3-31,32)) && (c3 <= floord(tmax,32)) && (c3 >= 1)) {
        for (c6=32*c3;c6<=32*c3+31;c6++) {
            S2(32*c3-1,-32*c3+c6+1,0) ;
        }
        for (c5=32*c3;c5<=32*c2+31;c5++) {
          for (c6=32*c3;c6<=32*c3+31;c6++) {
              S2(32*c3-1,-32*c3+c6+1,-32*c3+c5+1) ;
              S3(32*c3-1,-32*c3+c6+1,-32*c3+c5+1) ;
          }
        }
      }
      if ((c1 <= floord(32*c2+32*c3-1,32)) && (c1 >= ceild(64*c2+64*c3-63,64)) && (c2 <= floord(64*c3-1,64)) && (c2 >= ceild(64*c3-61,64)) && (c3 <= floord(2*tmax-1,64)) && (c3 >= 1)) {
          S4(32*c3-1,0,0) ;
        for (c6=ceild(64*c3+1,2);c6<=32*c3+31;c6++) {
            S4(32*c3-1,-32*c3+c6,0) ;
        }
        for (c5=ceild(64*c3+1,2);c5<=32*c2+31;c5++) {
            S4(32*c3-1,0,-32*c3+c5) ;
          for (c6=ceild(64*c3+1,2);c6<=32*c3+31;c6++) {
              S4(32*c3-1,-32*c3+c6,-32*c3+c5) ;
          }
        }
      }
      if ((-c1 == -c2-c3) && (c1 <= min(floord(128*c3-1,64),floord(64*c3+2*tmax-63,64))) && (c1 >= max(ceild(16*c3-15,16),ceild(32*c3-15,16)))) {
          S4(32*c1-32*c3+30,0,0) ;
        for (c6=ceild(64*c1-64*c3+63,2);c6<=32*c3+31;c6++) {
            S4(32*c1-32*c3+30,-32*c1+32*c3+c6-31,0) ;
        }
      }
      if ((-c1 == -c2-c3) && (c1 >= max(ceild(128*c2-61,64),ceild(16*c2-15,16))) && (c1 <= min(floord(128*c2-1,64),floord(64*c2+2*tmax-63,64)))) {
          S4(32*c1-32*c2+30,0,0) ;
        for (c5=ceild(64*c1-64*c2+63,2);c5<=32*c2+31;c5++) {
            S4(32*c1-32*c2+30,0,-32*c1+32*c2+c5-31) ;
        }
      }
      if ((-c1 == -c2-c3) && (c1 <= min(floord(64*c2+2*tmax-63,64),floord(64*c2-ny+1,32))) && (c1 >= max(ceild(16*c2-15,16),ceild(128*c2-2*ny-59,64)))) {
        for (c5=32*c2;c5<=floord(64*c1-64*c2+2*ny+59,2);c5++) {
            S4(32*c1-32*c2+30,0,-32*c1+32*c2+c5-31) ;
        }
          S4(32*c1-32*c2+30,0,ny-1) ;
      }
      if ((-c1 == -c2-c3) && (c1 >= max(ceild(16*c2-15,16),ceild(128*c2-2*ny+3,64))) && (c1 <= min(floord(64*c2+2*tmax-63,64),floord(128*c2-63,64)))) {
        for (c5=32*c2;c5<=32*c2+31;c5++) {
            S4(32*c1-32*c2+30,0,-32*c1+32*c2+c5-31) ;
        }
      }
      if ((-c1 == -2*c2) && (-c1 == -2*c3) && (c1 <= floord(2*tmax-63,32)) && (c1 >= -1)) {
        if (c1%2 == 0) {
            S4(16*c1+30,0,0) ;
        }
      }
      if ((c1 >= ceild(128*c2-1,64)) && (c1 <= floord(32*c2+15,16)) && (c2 <= min(floord(32*c3-nx+1,32),floord(2*tmax-63,64))) && (c2 >= max(ceild(64*c3-2*nx-59,64),0))) {
        for (c6=32*c3;c6<=floord(64*c2+2*nx+59,2);c6++) {
            S4(32*c2+30,-32*c2+c6-31,0) ;
        }
          S4(32*c2+30,nx-1,0) ;
      }
      if ((c1 >= ceild(128*c2-1,64)) && (c1 <= floord(32*c2+15,16)) && (c2 >= max(ceild(32*c3-nx+2,32),0)) && (c2 <= min(floord(2*tmax-63,64),c3-1))) {
        for (c6=32*c3;c6<=32*c3+31;c6++) {
            S4(32*c2+30,-32*c2+c6-31,0) ;
        }
      }
      if ((c1 >= ceild(32*c2+tmax-32,32)) && (c2 >= ceild(tmax-31,32)) && (c3 >= ceild(tmax-31,32))) {
        for (c5=max(32*c2,tmax);c5<=min(tmax+ny-1,32*c2+31);c5++) {
          for (c6=max(tmax,32*c3);c6<=min(32*c3+31,tmax+nx-1);c6++) {
              S4(tmax-1,c6-tmax,c5-tmax) ;
          }
        }
      }
      if ((c1 <= min(min(floord(64*c2+2*tmax-65,64),c2+c3-1),floord(64*c2-1,32))) && (c1 >= ceild(128*c2-2*ny-61,64))) {
        for (c5=max(32*c2,32*c1-32*c2+32);c5<=min(32*c2+31,32*c1-32*c2+ny+31);c5++) {
          for (c6=32*c3;c6<=min(32*c3+31,32*c1-32*c2+nx+31);c6++) {
              S4(32*c1-32*c2+31,-32*c1+32*c2+c6-32,-32*c1+32*c2+c5-32) ;
          }
        }
      }
      if ((-c1 == -c2-c3) && (c1 <= min(floord(64*c3-1,32),floord(32*c3+tmax-32,32)))) {
          S1(32*c1-32*c3+31,0) ;
        for (c6=32*c1-32*c3+32;c6<=32*c3+31;c6++) {
            S2(32*c1-32*c3+31,-32*c1+32*c3+c6-31,0) ;
        }
      }
      if ((-c1 == -c2-c3) && (c1 >= ceild(128*c2-63,64)) && (c1 <= min(floord(32*c2+tmax-32,32),floord(64*c2-1,32)))) {
        for (c5=max(32*c1-32*c2+31,32*c2);c5<=floord(64*c1-64*c2+63,2);c5++) {
            S1(32*c1-32*c2+31,-32*c1+32*c2+c5-31) ;
        }
        for (c5=32*c1-32*c2+32;c5<=32*c2+31;c5++) {
            S1(32*c1-32*c2+31,-32*c1+32*c2+c5-31) ;
            S3(32*c1-32*c2+31,0,-32*c1+32*c2+c5-31) ;
        }
      }
      if ((-c1 == -c2-c3) && (c1 <= min(floord(32*c2+tmax-32,32),2*c2-1))) {
        for (c5=32*c2;c5<=min(32*c2+31,32*c1-32*c2+ny+30);c5++) {
            S1(32*c1-32*c2+31,-32*c1+32*c2+c5-31) ;
            S3(32*c1-32*c2+31,0,-32*c1+32*c2+c5-31) ;
        }
      }
      if ((-c1 == -c2-c3) && (c1 >= ceild(128*c3-1,64)) && (c1 <= min(floord(32*c3+tmax-32,32),2*c3))) {
          S1(32*c1-32*c3+31,0) ;
      }
      if ((c1 >= 2*c2) && (c2 <= min(floord(64*c3-63,64),floord(tmax-32,32)))) {
        for (c6=max(32*c2+32,32*c3);c6<=min(32*c2+nx+30,32*c3+31);c6++) {
            S2(32*c2+31,-32*c2+c6-31,0) ;
        }
      }
    }
  }
}

	return 0;
}
