/* #include <stdio.h> */
/* #include <stdlib.h> */
/* #include <mkl.h> */

/* #include "decls.h" */
#define N 4000

#define alpha 1
#define beta 1

#define CblasRowMajor 1
#define CblasTrans 1
#define CblasNoTrans 1

double A[N][N];
double B[N][N];

double x[N];
double u1[N];
double u2[N];
double v2[N];
double v1[N];
double w[N];
double y[N];
double z[N];
/* #include "util.h" */

void cblas_dcopy(int, ...);
void cblas_dger( int, ...);
void cblas_dgemv(int, ...);

void* malloc(unsigned long);

main()
{
    double t_start, t_end;
    int i, j;
    int M=N;
    double *a, *b;

    a = (double *) malloc(sizeof(double)*M*M);
    b = (double *) malloc(sizeof(double)*M*M);

    for( i=0; i<M; i++){
        for( j=0; j<N; j++){
            a[i*M+j]= A[i][j]; 
        }
    }

    cblas_dcopy(M*N, a, 1, b, 1);
    cblas_dger(CblasRowMajor, M, N, 1.0, u1, 1, v1, 1, b, N);
    cblas_dger(CblasRowMajor, M, N, 1.0, u2, 1, v2, 1, b, M);
    cblas_dcopy(N, z, 1, x, 1);
    cblas_dgemv(CblasRowMajor,CblasTrans,M,N,beta,b,M,y,1,1.0,x,1);
    cblas_dgemv(CblasRowMajor,CblasNoTrans,M,N,alpha,b,M,x,1,0.0,w,1);


#ifdef TEST
    print_array();
#endif

    return 0;
}

