/* #include <stdio.h> */
/* #include <stdlib.h> */
/* #include <math.h> */
/* #include <unistd.h> */
/* #include <sys/time.h> */

/* #include <omp.h> */

/* #include "decls.h" */
#define N 2048
double a[N][N+13];
/* #include "util.h" */
double L[N][N];
double U[N][N];

int printf(const char*, ...);
double round(double);

void init_array()
{
    int i, j, k;

    /* have to initialize this matrix properly to prevent 
     * division by zero
     */
    for (i=0; i<N; i++) {
        for (j=0; j<N; j++) {
            L[i][j] = 0.0;
            U[i][j] = 0.0;
        }
    }

    for (i=0; i<N; i++) {
        for (j=0; j<=i; j++) {
            L[i][j] = i+j+1;
            U[j][i] = i+j+1;
        }
    }


    for (i=0; i<N; i++) {
        for (j=0; j<N; j++) {
            for (k=0; k<N; k++) {
                a[i][j] += L[i][k]*U[k][j];//i==j?1:0;
            }
        }
    }
}


void print_array()
{
    int i, j;

    for (i=0; i<N; i++) {
        for (j=0; j<N; j++) {
            printf("%lf ", round(a[i][j]));
            if (j%80 == 79) printf("\n");
        }
        printf("\n");
    }
    printf("\n");
}

int main()
{
	int i, j, k;
    double t_start, t_end;

	init_array() ;

#pragma scop
    for (k=0; k<N; k++) {
        for (j=k+1; j<N; j++)   {
            a[k][j] = a[k][j]/a[k][k];
        }
        for(i=k+1; i<N; i++)    {
            for (j=k+1; j<N; j++)   {
                a[i][j] = a[i][j] - a[i][k]*a[k][j];
            }
        }
    }
#pragma endscop

        print_array();
    return 0;
}
