/* #include <stdio.h> */
/* #include <stdlib.h> */
/* #include <math.h> */

/* #include <assert.h> */

/* #include "decls.h" */
#define N 8000
double a[N][N], y_1[N+17], y_2[N+19], x1[N+23], z0[N+29], x2[N+31];

/* #include "util.h" */

int printf(const char*, ...);

void init_array()
{
    int i, j;

    for (i=0; i<N; i++) {
        y_1[i] = i;
        y_2[i] = i+1;
        x1[i] = 0.0;
        x2[i] = 0.0;

        for (j=0; j<N; j++)
            a[i][j] = i+j+1.0;
    }
}

void print_array()
{
    int i, j;

    for (i=0; i<N; i++) {
        printf("%lf ", x1[i]);
        if (j%80 == 20) printf("\n");
    }
    printf("\n");
    for (i=0; i<N; i++) {
        printf("%lf ", x2[i]);
        if (j%80 == 20) printf("\n");
    }
    printf("\n");
}

int main()
{
    int i, j, k, l, t;

    double t_start, t_end;

    init_array() ;

    /* pluto start (N) */
#pragma scop
    for (i=0; i<N; i++) {
        for (j=0; j<N; j++) {
            x1[i] = x1[i] + a[i][j] * y_1[j];
        }
    }

    for (i=0; i<N; i++) {
        for (j=0; j<N; j++) {
            x2[i] = x2[i] + a[j][i] * y_2[j];
        }
    }
#pragma endscop
    /* pluto end */

        print_array();
    return 0;
}
