extern int array1[8]; // made unsafe in directUsage
extern int array2[8]; // safe (but a local version is not)

int externFunction(int*);

int directUsage(void)
{
    // Passing the array as a function argument is unsafe.
    externFunction(array1);
}

int goodUseOfA(int a)
{
    // Safe, local use, shadowed by another, bad use.
    int array1[8];
    array1[0] = a;
    // This local operation should be safe for the array, but we must recognize
    // that this is actually the same array as in directUsage.
    {
        extern int array1[8];
        array1[0] = a;
    }
}

int badUse(int a)
{
    int array2[8];           // Unsafe use.
    externFunction(array2);
    {
        extern int array2[8]; // Safe to pad.
        array2[0] = a;
    }
}
