/* #include <stdio.h> */
/* #include <stdlib.h> */
/* #include <math.h> */
/* #include <sys/time.h> */

int printf (const char*, ...);

#define NMAX 2000

static double a[NMAX][NMAX], b[NMAX][NMAX], c[NMAX][NMAX];

void ssymm(long N) {
  int i,j,k;

#pragma scop
  for (i=0; i<N; i++) {
    for (j=0; j<N; j++) {
      for (k=0; k<j-1; k++) {
        c[i][k] += a[j][k] * b[i][j];
        c[i][j] += a[j][j] * b[i][j];
      }
      c[i][j] += a[j][j] * b[i][j];
    }
  }
#pragma endscop
}


int main()
{
  long N=NMAX;
  int i,j;
  double t_start, t_end;

    N = N/2;

  for (i = 0; i < NMAX; i++) {
    for (j = 0; j < NMAX; j++) {
      c[i][j] = 0.0;
      a[i][j] = b[i][j] = i*j*0.5 / NMAX;
    }
  }

  ssymm(N);

    for (i = 0; i < NMAX; i++) {
      for (j = 0; j < NMAX; j++) {
        if ((j+1)%80==0) printf("\n");
        printf("%lf ", c[i][j]);
      }
    }
    printf("\n");

  return 0;
}
